
#import "SCloud.h"
#import "Shoot.h"

@implementation SCloud

- activate:sender :(int)tag
{
    NSSize tsize = {96,48};
    NSSize t2 = {48, 24};
    float windSpeed = [sender windSpeed];
    
    [super activate:sender :tag];

    [self reinitWithImage:@"Scloud"
	    frameSize:&tsize
	    numFrames:1
	    shape: RECT
	    alliance: NEUTRAL
	    radius: 50
	    buffered: YES
//	    x: (windSpeed < 0) ? xOffset + 48 : -xOffset - 48
	    x: randBetween(-xOffset,xOffset)
	    y: yOffset - randBetween(36,yOffset)
	    theta: - PI / 2
	    vel: windSpeed * (1 - tag * 0.2)
	    interval: 0
	    distToCorner: &t2];

    return self;
}

- positionChanged
{
    BOOL didBounce;
    float distx, disty, myX, myY;
    distx = (xOffset+distToCorner.width);
    disty = (yOffset+distToCorner.height);
    didBounce = [self bounceAtDistance:distx :disty];
    if (didBounce) {
	xv *= -1; // unbounce us
	myX = ((xv < 0) ? xOffset + 47 : -xOffset - 47);
	myY = y;
    	[self setFrameOrigin:NSMakePoint(myX, myY)];
    }
    [super positionChanged];
    return self;
}

@end
