
#import "SGunTower.h"

@implementation SGunTower

- activate:sender :(int)tag
{
    NSSize sz, sz2;
    NSRect r;
    Actor *gun = sender;

    sz.height = gun->y + yOffset - gun->distToCorner.height + 3;
    sz.width = gun->frameSize.width;
    sz2.width = sz.width / 2;
    sz2.height = sz.height / 2;

    [super activate:sender :tag];

    [self reinitWithImage:@""
	    frameSize:&sz
	    numFrames:1
	    shape: RECT
	    alliance: GOOD
	    radius: 50
	    buffered: YES
	    x: gun->x
	    y: -yOffset + sz2.height
	    theta: 0
	    vel: 0
	    interval: 0
	    distToCorner: &sz2];

    image = [[NSImage alloc] initWithSize:sz];
    [image lockFocus];
    r.size = sz;
    r.origin.x = r.origin.y = 0;
    if ([[NSApp mainWindow] canStoreColor]) {
        PSsetrgbcolor(0.0,0.2,0.6);
    } else {
        PSsetgray(0.4);
    }
    NSRectFill(r);
    r.origin.x += 2;
    r.size.width -= 4;
    r.size.height -= 2;
    if ([[NSApp mainWindow] canStoreColor]) {
        PSsetrgbcolor(0.0,0.1,0.3);
    } else {
        PSsetgray(0.333);
    }
    NSRectFill(r);
    [image unlockFocus];

    return self;
}

- performCollisionWith:(Actor *) dude
{
    // don't go away
    return self;
}

@end
