#import "SimpleStorage.h"
#import <AppKit/AppKit.h>

@implementation SimpleStorage

#define elementPos(x) (dataPtr+(x*elementSize))

- (void*) elementAt: (unsigned)index
{
  if (index> maxElements) index=numElements;
  return elementPos(index);
}

-(void) addElement:(void *)anElement;
{
  if ((numElements+1)> maxElements) {
    maxElements=numElements+1; 
    dataPtr = realloc(dataPtr,elementSize*maxElements); 
    bzero(elementPos(numElements),elementSize); 
  } 
  memcpy(elementPos(numElements),anElement,elementSize);
  numElements++;
}

-(void)setNumSlots:(unsigned)numSlots;
{
// TODO  
}

- (void)empty;
{
  numElements=0;
//  maxElements=1000;
//  dataPtr = realloc(dataPtr,elementSize);
}

-(void)removeAllObjects;
{
  [self empty];
}

- (unsigned)count;
{
  return numElements;
}

- initCount:(unsigned)count elementSize:(unsigned)sizeInBytes description:(const char *)descriptor;
{
  self = [super init];

  elementSize =sizeInBytes;

  description=[[NSString stringWithCString:descriptor] retain];

  numElements=0;
  maxElements=MAX(1000,count);

  dataPtr = malloc(elementSize * maxElements);
  bzero(dataPtr,elementSize * maxElements);

  return self;
}

@end


@implementation SimpleStorage (XoxExt)
- (id *) idAt:(int)ndx
{
        id *actorArray = (id *)dataPtr;
        return actorArray + ndx;
}
- actorAt:(int)ndx
{
        return *([self idAt:ndx]);
}

- replaceActorAt:(unsigned int)index with:theActor
{
        id *theActorPtr = [self idAt:index];
        *theActorPtr = theActor;
        return self;
}
@end
