
#import "SpaxeWars.h"
#import "BackView.h"
#import "Ship.h"
#import "ActorMgr.h"
#import "SoundMgr.h"
#import "SWBullet.h"
#import "SWShip.h"
#import "SWSpaceGen.h"
#import "SWSun.h"
#import "SWMeteor.h"
#import "GOLetter.h"
#import "Explosion.h"
#import "Thinker.h"


int xx_swbullet, xx_swship, xx_swspace;
float sw_gravity;
int sw_bulletSpeed, sw_bounce, sw_meteors, sw_nastyShots;
int sw_bulletMass;

@implementation SpaxeWars

- newGame
{
	dartKills = clawKills = 0;
	[clawKillsText setIntValue:clawKills];
	[clawKillsText display];
	[dartKillsText setIntValue:dartKills];
	[dartKillsText display];
	return self;
}

// invoked only by the actor manager
- _createLevel:(int)lev
{
	int i;
	NSRect r;
	char title[40];

	goToNextLevel = explosionCount = goodBullets = badBullets = 0;

	goodShip = [actorMgr newActor:xx_swship for:self tag:GOOD];
	badShip = [actorMgr newActor:xx_swship for:self tag:EVIL];

	space = [actorMgr newActor:xx_swspace	for:self tag:0];
	if (sun) sun = [actorMgr newActor:(int)[SWSun class] for:self tag:0];
	for (i=0; i<sw_meteors; i++)
		[actorMgr newActor:(int)[SWMeteor class] for:self tag:0];
	r = [mainView bounds];
	[space newSize:r.size];

	sprintf(title,"Spaxe Wars");
	[[mainView window] setTitle:[NSString stringWithCString:title]];

	return self;
}

- infoView
{
	return infoView;
}

- didActivate:(Actor *)theActor
{
	if(theActor->actorType == xx_explosion)
		explosionCount++;
	else if(theActor->actorType == xx_swbullet)
	{
		(theActor->theta == 0.) ? goodBullets++ : badBullets++;
	}
	else
	{
	
	}
	return self;
}

- didRetire:(Actor *)theActor
{
	if(theActor->actorType == xx_swship)
	{
		if (theActor->alliance == GOOD)
		{
			[clawKillsText setIntValue:++clawKills];
			[clawKillsText display];
		}
		else
		{
			[dartKillsText setIntValue:++dartKills];
			[dartKillsText display];
		}

		if (dartKills >= 10 || clawKills >= 10)
		{
			if ([actorMgr gameStatus] != GAME_DYING)
				[GOLetter gameOver:self];
			[actorMgr setGameStatus: GAME_DYING];
			goToNextLevel = 0;
		}
		else goToNextLevel = 1;
	}
	else if(theActor->actorType == xx_explosion)
	{
		if ((--explosionCount <= 0) && goToNextLevel)
		{
			[actorMgr requestLevel: 1];
		}
	}
	else if(theActor->actorType == xx_swbullet)
	{
		(theActor->theta == 0.) ? goodBullets-- : badBullets--;
	}
	else
	{
	
	}

	return self;
}



- (void)keyDown:(NSEvent *)theEvent
{
  NSString *theKeys = [theEvent characters];
  char keyBuf[2];

  [theKeys getCString:keyBuf maxLength:1];
  if ([theEvent isARepeat] > 0) return;

  switch(*keyBuf)
    {
    case 'z':		// rotate left
      [goodShip setTurning:LEFT down:YES time:[theEvent timestamp]];
      break;
    case 'x':		// rotate right
      [goodShip setTurning:RIGHT down:YES time:[theEvent timestamp]];
      break;
    case '.':		// fire
      [goodShip fire];
      break;
    case ',':		// thrust
      [goodShip setThrusting:YES time:[theEvent timestamp]];
      break;
    case ' ':		// shields
      [goodShip setShields:1];
      break;

    case '1':		// rotate left
      [badShip setTurning:LEFT down:YES time:[theEvent timestamp]];
      break;
    case '2':		// rotate right
      [badShip setTurning:RIGHT down:YES time:[theEvent timestamp]];
      break;
    case '9':		// fire
      [badShip fire];
      break;
    case '6':		// thrust
      [badShip setThrusting:YES time:[theEvent timestamp]];
      break;
    case '\003':		// shields
      [badShip setShields:1];
      break;
      }
}

- (void)keyUp:(NSEvent *)theEvent
{
  NSString *theKeys = [theEvent characters];
  char keyBuf[2];

  [theKeys getCString:keyBuf maxLength:1];
  if ([theEvent isARepeat] > 0) return;

  switch(*keyBuf)
    {
    case 'z':		// rotate left
      [goodShip setTurning:LEFT down:NO time:[theEvent timestamp]];
      break;
    case 'x':		// rotate right
      [goodShip setTurning:RIGHT down:NO time:[theEvent timestamp]];
      break;
    case ',':		// thrust
      [goodShip setThrusting:NO time:[theEvent timestamp]];
      break;
    case ' ':		// shields
      [goodShip setShields:0];
      break;

    case '1':		// rotate left
      [badShip setTurning:LEFT down:NO time:[theEvent timestamp]];
      break;
    case '2':		// rotate right
      [badShip setTurning:RIGHT down:NO time:[theEvent timestamp]];
      break;
    case '6':		// thrust
      [badShip setThrusting:NO time:[theEvent timestamp]];
      break;
    case '\003':		// shields
      [badShip setShields:0];
      break;
      }
}

- scenarioSelected
{
	goodShip = [actorMgr newActor:xx_swship for:self tag:GOOD];
	badShip = [actorMgr newActor:xx_swship for:self tag:EVIL];
	[goodShip scenarioSelected];
	[badShip scenarioSelected];
	return self; 
}

- scenarioDeselected
{	return self; }

- newSize:(NSSize)s
{
	[space newSize:s];
	return self;
}

- (COLLISION_PARADIGM)collisionParadigm
{
	return GOOD_V_EVIL;
}

- init
{
  NSString *path;

  id cv, subviews;

  [super init];

  if (path = [[NSBundle bundleForClass:[self class]] pathForResource:@"spaxewars" ofType:@"nib"])
    {
    [NSBundle loadNibFile:path externalNameTable:[NSDictionary dictionaryWithObjectsAndKeys:self, @"NSOwner", nil] withZone:[self zone]];

    cv = [uselessBox contentView];
    subviews = [cv subviews];
    while ([subviews count] > 0)
      [scoreView addSubview:[subviews objectAtIndex:0]];

    }

  xx_swbullet = (int)[SWBullet class];
  xx_swship = (int)[SWShip class];
  xx_swspace = (int)[SWSpaceGen class];

  [self adjustSettings:self];

  [[NSApp delegate] addImageResource:"explosionM" for: [Explosion class]];
  [[NSApp delegate] addImageResource:"explosionS" for: [Explosion class]];
  [[NSApp delegate] addSoundResource:	SHIPSND];

  return self;
}

- tileScenario
{
	NSRect r;
	float f;

	r = [gcontentView bounds];
	r.size.width -= 60;
	f = r.size.width;
	[abackView setFrame:r];
	r = [gcontentView bounds];
	r.size.width = 60;
	r.origin.x = f;
	[scoreView setFrame:r];
	[gcontentView addSubview:abackView];
	[gcontentView addSubview:scoreView];
	return abackView;
}

- (int) bullets : (int) type
{
	return (type == GOOD) ? goodBullets : badBullets;
}

- adjustSettings:sender
{
	switch([gravityMatrix selectedRow])
	{
		case 0: sw_gravity = 30000; break;
		case 1: sw_gravity = 0; break;
		case 2: sw_gravity = -30000; break;
		case 3: sw_gravity = -66000; break;
	}
	switch([bulletMatrix selectedRow])
	{
		case 0: sw_bulletSpeed = 13; break;
		case 1: sw_bulletSpeed = 22; break;
		case 2: sw_bulletSpeed = 34; break;
	}

	if ([[settingsMatrix cellAtRow:0 column:0] state])
	{	// sun enabled
		if (!sun) sun = [actorMgr newActor:(int)[SWSun class] for:self tag:0]; 
	}
	else
	{
		if (sun) [actorMgr destroyActor:sun];
		sun = nil;
	}

	sw_bounce = ([[settingsMatrix cellAtRow:1 column:0] state]);
	sw_nastyShots = ([[settingsMatrix cellAtRow:2 column:0] state]);
	sw_bulletMass = ([[settingsMatrix cellAtRow:3 column:0] state]);

	sw_meteors = ([meteorsSlider intValue]);

	return self;
}

@end




