#import "DumbRocket.h"
#import "../SoundMgr.h"
#import "../ActorMgr.h"

@implementation DumbRocket
- activate:sender :(int)tag
{
        NSSize tsize = {42,42};
        NSSize tsize2 = {21,21};
        Actor *dude = (Actor *)sender;

        employed = YES;

        [self reinitWithImage:@"rocket1"
                frameSize:&tsize
                numFrames:24
                shape: RECTCIRC
                alliance: EVIL
                radius: 21
                buffered: YES
                x: dude->x
                y: dude->y
                theta: dude->theta
                vel: dude->vel
                interval: 50
                distToCorner: &tsize2];

        hits = 0;
        maxHits = randBetween(3,6);
        thrustState = maxHits;
        return self;
}

- positionChanged
{
        float t_theta;
        if (timeInMS > changeTime)
        {
                changeTime = timeInMS + interval;
                if (++thrustState & 1) image = r1;
                else image = r2;
        }

        t_theta = theta + (7.5 * PI / 180.0);
        if (t_theta >= 2.0*PI) t_theta -= 2.0*PI;
        frame = (t_theta/(15.0 * PI / 180.0));

        return self;
}

- performCollisionWith:(Actor *) dude
{
        id ret = self;
        if (++hits >= maxHits)
        {
                [soundMgr playSound: (EXP2SND) at:0.5];
                [actorMgr newActor:xx_explosion for:self tag:1];
                ret = [super performCollisionWith: dude];
        }
        else
        {
//		[soundMgr playSound: FUTILITYSND at:0.5];

//		[soundMgr playSound: FUTILITYSND at:0.5];
        }

        return ret;
}
@end
