
#import "RocketMatrix.h"
#import "DumbRocket.h"
#import "ActorMgr.h"
#import "SoundMgr.h"
#import "Explosion.h"
#import "Xoxeroids.h"
#import "Rocket.h"


@implementation RocketMatrix

- activate:sender :(int)tag
{
	MatrixData md;

	md.autofill = YES;
	md.whichClass = [DumbRocket class];
	md.alliance = EVIL;
	md.x = randBetween(xOffset,5*xOffset);
	md.y = randBetween(yOffset,5*yOffset);
	md.theta = randBetween(0,2*PI);
	md.vel = randBetween(7,12);
	md.rows = randBetween(4,6.9);
	md.columns = 4;
	md.xgap = randBetween(20,50);
	md.ygap = randBetween(20,50);
	md.actWidth = 42;
	md.actHeight = 42;
	md.interval = 200;
	md.modifyThetas = YES;

	[super activate:self :(int)&md];
	return self;
}

- positionChanged
{
	[self wrapAtDistance: (3*xOffset) :(3*yOffset)];
	while (theta < 0) theta += (2*PI);
	while (theta >= (2*PI)) theta -= (2*PI);
	return self;
}

- calcDxDy:(NSPoint *)dp
{
	if (timeInMS > changeTime)
	{
		changeTime = timeInMS + interval;
		theta += randBetween(-PI/10.0,PI/10.0);
		xv = vel * -sin(theta);
		yv = vel * cos(theta);
	}
	[super calcDxDy:dp];
	return self;
}



@end