/********************************************************************************

File:       CustomGridView.h

This is a simple view that just draws a grid of rectangles, with text inside them.
It demonstrates how to provide pagination hints within a printable view, by only
breaking pages on a grid boundary.

The coordinate system of the custom view is flipped, primarily because the NSString
drawing APIs only work correctly in a flipped view.  Without the text drawing, there
is no reason why the coordinate system couldn't be used normally.

This sample is based on a NeXTStep sample written by Samuel Streeper.

Written by: Timothy Carroll

Created:    Wed 15-Oct-1997

Copyright:  (c) 1991, 1997 by Apple Computer, Inc., all rights reserved.

Change History (most recent first):

You may incorporate this sample code into your applications without
restriction, though the sample code has been provided "AS IS" and the
responsibility for its operation is 100% yours.  However, what you are
not permitted to do is to redistribute the source as "DSC Sample Code"
after having made changes. If you're going to re-distribute the source,
we require that you make it clear in the source that the code was
descended from Apple Sample Code, but that you've made changes.
********************************************************************************/


#import <AppKit/AppKit.h>

@interface CustomGridView : NSView
{
}

// initializer
- (id) initWithFrame: (NSRect) frameRect;

// We override for a flipped coordinate system
- (BOOL) isFlipped;

// set up any defaults when the window is opened.
- (void) awakeFromNib;

// drawing functions
- (void) drawRect: (NSRect) aRect;
- (void) drawGridPageAt: (NSPoint) point
	     withNumber: (int) number
	       darkFlag: (int) flag;

// Printing Functions
- (BOOL) knowsPagesFirst: (int *) firstPageNum last: (int *) lastPageNum;
- (NSRect) rectForPage: (int) page;
/*
- (void) addToPageSetup;
- (void) endPrologue;
*/
- (void) adjustPageHeightNew:(float *)newBottom
			 top:(float)oldTop
		      bottom:(float)proposedBottom
		       limit:(float)bottomLimit;
- (void) adjustPageWidthNew:(float *)newRight
		       left:(float)oldLeft
		      right:(float)proposedRight
		      limit:(float)rightLimit;

// Calculates the scaling factor required to draw one full grid unit inside the current page;
- (float) scale;
@end
