/********************************************************************************

File:       CustomPageLayout.h

This is a subclass of NSPageLayout, and implements a version of PageLayout that
knows about our additional pagination options.  The additional features are set
using an accessory view.  Instead of subclassing a panel, you should usually
just have a controller object for the accessory view, but NSPageLayout doesn't
provide a way for the accessory view to add to the PageInfo record.

This sample is based on a NeXTSTEP 3.3 sample written by Samuel Streeper.

Written by: Timothy Carroll

Created:    Wed 15-Oct-1997

Copyright:  (c) 1991, 1997 by Apple Computer, Inc., all rights reserved.

Change History (most recent first):

You may incorporate this sample code into your applications without
restriction, though the sample code has been provided "AS IS" and the
responsibility for its operation is 100% yours.  However, what you are
not permitted to do is to redistribute the source as "DSC Sample Code"
after having made changes. If you're going to re-distribute the source,
we require that you make it clear in the source that the code was
descended from Apple Sample Code, but that you've made changes.
********************************************************************************/


#import <AppKit/AppKit.h>
#import "CustomPrintInfo.h"


@interface CustomPageLayout : NSPageLayout
{
	id customOptionsView;
	id margins;
	id centerButtons;
	id horButtons;
	id vertButtons;
	id paginationButtons;
}

+ (id) customLayout;
- (int) runModal;
- (void) pickedUnits:(id)sender;
- (void) readPrintInfo;
- (void) writePrintInfo;


@end
