#import "AppController.h"
#import "MLSystemInformation.h"

@implementation AppController

// accessor methods
- (void) setSysInfo:(MLSystemInformation *)newSysInfo
{
    if (sysInfo != newSysInfo)
    {
        [sysInfo release];
        sysInfo = [newSysInfo retain];
    }
}

- (MLSystemInformation *)sysInfo
{
    return sysInfo;
}

// notification receivers
- (void) applicationDidFinishLaunching:(NSNotification *)aNotification
{
    MLSystemInformation *newSysInfo;
    
    newSysInfo = [[MLSystemInformation alloc] init];
    [self setSysInfo:newSysInfo];
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(performanceUpdate:)
                                                 name:performanceUpdateNotification
                                               object:newSysInfo];
    [newSysInfo release];
}

- (void) applicationWillTerminate:(NSNotification *)aNotification
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [self setSysInfo:nil];
}

- (void) performanceUpdate:(NSNotification *)aNotification
{
    NSNumber *workValue;
    
    workValue = [[NSNumber alloc] initWithDouble:[[aNotification object] runQueue1]];
    [runQueue1Field setObjectValue:workValue];
    [workValue release];

    workValue = [[NSNumber alloc] initWithDouble:[[aNotification object] runQueue5]];
    [runQueue5Field setObjectValue:workValue];
    [workValue release];

    workValue = [[NSNumber alloc] initWithDouble:[[aNotification object] runQueue15]];
    [runQueue15Field setObjectValue:workValue];
    [workValue release];

    workValue = [[NSNumber alloc] initWithDouble:[[aNotification object] machFactor1]];
    [machFactor1Field setObjectValue:workValue];
    [workValue release];

    workValue = [[NSNumber alloc] initWithDouble:[[aNotification object] machFactor5]];
    [machFactor5Field setObjectValue:workValue];
    [workValue release];

    workValue = [[NSNumber alloc] initWithDouble:[[aNotification object] machFactor15]];
    [machFactor15Field setObjectValue:workValue];
    [workValue release];

}

@end
