// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniNetworking/ONHost.h,v 1.7 1998/12/08 04:08:39 kc Exp $

#import <OmniBase/OBObject.h>

@class NSArray, NSMutableArray;
@class ONHostAddress;

@interface ONHost : OBObject
{
    NSString *hostname;
    NSString *canonicalHostname;
    NSMutableArray *addresses;
}

+ (NSString *)domainName;
+ (NSString *)localHostname;

+ (ONHost *)hostForHostname:(NSString *)hostname;
+ (ONHost *)hostForAddress:(ONHostAddress *)anAddress;

- (NSString *)hostname;
- (NSArray *)addresses;
- (NSString *)canonicalHostname;
- (NSString *)domainName;

@end

#import "FrameworkDefines.h"

// Exceptions which may be raised by this class
OmniNetworking_EXTERN NSString *ONHostNotFoundExceptionName;
OmniNetworking_EXTERN NSString *ONHostNameLookupErrorExceptionName;
OmniNetworking_EXTERN NSString *ONHostHasNoAddressesExceptionName;
OmniNetworking_EXTERN NSString *ONGetHostByNameNotFoundExceptionName;
