// Copyright 1998 Omni Development, Inc.  All rights reserved.


#import "OLBookshelfController.h"

#import "OLIndexedFolder.h"
#import "OLIndexFolderDragging.h"
#import "OWShelfView.h"
#import "OWShelfFormatter.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OmniAIAT/OmniAIAT.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniLibrarian/OLBookshelfController.m,v 1.6 1998/03/23 10:13:26 andrew Exp $")


@interface OLBookshelfController(Private)
- (BOOL)finishReadingFromFile;
- (IBAction)doubleClick:(id)sender;
@end


@implementation OLBookshelfController

- (NSString *)windowNibName;
{
    return @"Bookshelf";
}

- (BOOL)writeToFile:(NSString *)aPath ofType:(NSString *)type;
{
#warning AFA: I am not paying attention to the file type
    NSMutableArray *array;
    NSMutableDictionary *bookshelfDictionary;
    NSMutableDictionary *info;
    OLIndexedFolder *folder;
    unsigned int row, column, maxRow, maxColumn;
    NSRect windowFrame;

    bookshelfDictionary = [NSMutableDictionary dictionary];
    array = [NSMutableArray array];
    maxRow = [shelf rows];
    maxColumn = [shelf columns];
#warning AFA: grabbing the window from the first windowController is pretty bogus, though it works for us
    windowFrame = [[[[self windowControllers] objectAtIndex:0] window] frame];

    [bookshelfDictionary setObject:[NSNumber numberWithFloat:windowFrame.size.height] forKey:@"windowHeight"];
    [bookshelfDictionary setObject:[NSNumber numberWithFloat:windowFrame.size.width] forKey:@"windowWidth"];
    if (splitView)	// in case this gets disconnected during development, we won't corrupt bookshelf files
        [bookshelfDictionary setObject:[NSNumber numberWithFloat:[splitView fraction]] forKey:@"splitViewFraction"];
    for (row = 0; row < maxRow; row++) {
        for (column = 0; column < maxColumn; column++) {
            folder = (OLIndexedFolder *)[shelf entryAtRow:row column:column];
            info = [folder infoDictionary];
            if (info) {
                NSMutableDictionary *targetDictionary;

                targetDictionary = [NSMutableDictionary dictionary];
                [targetDictionary setObject:info forKey:@"folderInfo"];
                [targetDictionary setObject:[NSNumber numberWithInt:row] forKey:@"row"];
                [targetDictionary setObject:[NSNumber numberWithInt:column] forKey:@"column"];
                if ([shelf selectedAtRow:row column:column])
                    [targetDictionary setObject:@"YES" forKey:@"selected"];
                [array addObject:targetDictionary];
            }
        }
    }
    [bookshelfDictionary setObject:array forKey:@"targets"];
    return [bookshelfDictionary writeToFile:aPath atomically:YES];
}

- (BOOL)readFromFile:(NSString *)aPath ofType:(NSString *)type;
{
#warning AFA: I am not paying attention to the file type
    if (!aPath)
        return YES;

#warning AFA: revert to saved does not work (presumably because I do not get windowControllerDidLoadNib: at that point, eh?)
    fileContentsDictionary = [[NSDictionary alloc] initWithContentsOfFile:aPath];
    if (![fileContentsDictionary objectForKey:@"targets"])
        return NO;

    return YES;
}

- (BOOL)finishReadingFromFile;
{
    NSNumber *splitViewFraction;
    NSNumber *windowWidth;
    NSNumber *windowHeight;
    NSArray *array;
    NSEnumerator *enumerator;
    NSDictionary *shelfTarget;
    OLIndexedFolder *folder;

    if (!fileContentsDictionary)
        return NO;
    
    windowWidth = [fileContentsDictionary objectForKey:@"windowWidth"];
    windowHeight = [fileContentsDictionary objectForKey:@"windowHeight"];
    if (windowWidth && windowHeight) {
        NSRect windowFrame;

        windowFrame = [[[[self windowControllers] objectAtIndex:0] window] frame];
        windowFrame.size.width = [windowWidth floatValue];
        windowFrame.size.height = [windowHeight floatValue];
        [[[[self windowControllers] objectAtIndex:0] window] setFrame:windowFrame display:YES];
    }

    splitViewFraction = [fileContentsDictionary objectForKey:@"splitViewFraction"];
    if (splitViewFraction)
        [splitView setFraction:[splitViewFraction floatValue]];

    array = [fileContentsDictionary objectForKey:@"targets"];
    enumerator = [array objectEnumerator];
    while ((shelfTarget = [enumerator nextObject])) {
        folder = [[OLIndexedFolder alloc] initWithInfoDictionary:[shelfTarget objectForKey:@"folderInfo"]];
        [shelf addEntry:folder selected:([[shelfTarget objectForKey:@"selected"] isEqualToString:@"YES"]) atRow:[[shelfTarget objectForKey:@"row"] intValue] andColumn:[[shelfTarget objectForKey:@"column"] intValue]];
        [folder release];
    }
    
    [fileContentsDictionary release];
    fileContentsDictionary = nil;

    return YES;
}

- (BOOL)revertToSavedFromFile:(NSString *)fileName ofType:(NSString *)type;
{
    BOOL success;

    success = [super revertToSavedFromFile:fileName ofType:type];
    if (success) {
        unsigned int row, column, maxRow, maxColumn;

        maxRow = [shelf rows];
        maxColumn = [shelf columns];
        for (row = 0; row < maxRow; row++) {
            for (column = 0; column < maxColumn; column++) {
#warning AFA: addEntry:selected:atRow:andColumn: is surely the wrong name (maybe setEntry:...?)
                [shelf addEntry:nil selected:NO atRow:row andColumn:column];
            }
        }
        
        success = [self finishReadingFromFile];
    }

    return success;
}

- (IBAction)query:(id)sender;
{
    NSEnumerator *enumerator;
    NSMutableArray *indices;
    OLIndexedFolder *folder;

    [currentQuery release];
    currentQuery = nil;

    enumerator = [[shelf selection] objectEnumerator];
    indices = [NSMutableArray array];
    while ((folder = [enumerator nextObject]))
        [indices addObject:[folder index]];
    if ([indices count] > 0)
        currentQuery = [[OAIQuery alloc] initWithQuery:[sender stringValue] onIndices:indices maxHits:50];

    [table reloadData];
    [sender selectText:nil];
}

- (IBAction)doubleClick:(id)sender;
{
    [[NSWorkspace sharedWorkspace] openFile:[currentQuery pathAtIndex:[table clickedRow]]];
}

- (void)windowControllerDidLoadNib:(NSWindowController *)windowController;
{
    OWShelfFormatter *formatter;
    OLIndexFolderDragging *dragSupport;

    [super windowControllerDidLoadNib:windowController];
    
    formatter = [[OWShelfFormatter alloc] init];
    [shelf setFormatter:formatter];
    [formatter release];
    dragSupport = [[OLIndexFolderDragging alloc] init];
    [shelf setDragSupport:dragSupport];
    [dragSupport release];
    [shelf setSpaceSize:NSMakeSize(80,80)];
    [shelf setMoveOnDrag:YES];
    [table setTarget:self];
    [table setDoubleAction:@selector(doubleClick:)];

    if (fileContentsDictionary)
        [self finishReadingFromFile];
}

// NSTableViewDataSource

- (int)numberOfRowsInTableView:(NSTableView *)tableView;
{
    return [currentQuery resultCount];
}

- (id)tableView:(NSTableView *)tableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row;
{
    if ([[tableColumn identifier] isEqualToString:@"Score"])
        return [NSString stringWithFormat:@"%0.2f", [currentQuery scoreAtIndex:row]];
    else
        return [[currentQuery filenameAtIndex:row] lastPathComponent];
}

// OWShelfViewDelegate

- (void)shelfViewSelectionChanged:(OWShelfView *)view;
{
}

- (void)shelfViewClick:(OWShelfView *)view;
{
}

- (void)shelfViewDoubleClick:(OWShelfView *)view;
{
}

- (void)shelfViewChanged:(OWShelfView *)view;
{
    [self updateChangeCount:NSChangeDone];
}

@end
