// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniLibrarian/OWShelfViewDragSupportProtocol.h,v 1.2 1998/02/25 10:57:39 kc Exp $

@class NSArray, NSString;
@class NSEvent, NSImage, NSPasteboard, NSView;
@class OAPasteboardHelper;

#import <Foundation/NSGeometry.h> // For NSPoint

@protocol OWShelfViewDragSupport <NSObject>

/* dragging in */
- (NSArray *)acceptedPasteboardTypes;
- (id)entryFromPropertyList:propertyList ofType:(NSString *)type;

/* dragging out */
- (NSImage *)dragImageForEntry:(id)anEntry;
- (void)declareTypesForEntry:(id)anEntry pasteboardHelper:(OAPasteboardHelper *)pasteboardHelper;

- (void)startDragOnEntry:anEntry fromView:(NSView *)aView image:(NSImage *)anImage atPoint:(NSPoint)location event:(NSEvent *)event pasteboardHelper:(OAPasteboardHelper *)pasteboardHelper;

@end
