/*
	Copyright 1995, Anderson Financial Systems Inc.  All Rights Reserved.
	Anderson Financial Systems, Inc.
	909 Sumneytown Pike, Suite 106
	Springhouse, PA 19477
	215 653 0911
 */

#import "FlowAccess_Protocol.h"

@protocol DocumentAccess

	/* frees internal resource
	 */
- (void)freeResource;

	/* close document 
 	 */
- (void)close;

	/* Returns the documents extension
	 */
- (NSString *)documentExtension;

- (NSString *)filename;

	/* Return flow with aName.
	 */
- (id <FlowAccess>)findFlowNamed:(NSString *)aName;

	/* Swaps a new image into an existing graphic (either type)
	*/
- (void)replaceFilename:(NSString *)filename forGraphicNamed:(NSString *)aName;
- (void)replaceImage:(bycopy in NSImage *)anImage forGraphicNamed:(NSString *)aName;

	/* Makes the document the focused document. If activate true makes WriteUp
	 * the active app.
	 */
- (void)makeMain:(BOOL)activate;

	/* Makes the document visible/invisible.
	 */
- (void)makeVisible:(BOOL)yn;

	/* print document with print panel.
	 */
- (void)print;

	/* Performs print with or without the print panel.
	 */
- (void)printWithPrintPanel:(BOOL)panel;

	/*  save document.
	 */
- (BOOL)save;

	/* Saves the document to the file specified in pathname.  
	 */
- (BOOL)saveToFile:(NSString *)pathname;

	/* Saves a template in the file specified by pathname. 
	 */
- (BOOL)saveToTemplateFile:(NSString *)pathname;

	/* Sets document Edited YES/NO
	 */
- (void)setEdited:(BOOL)flag;

	/* Returns YES if doc is edited
	 */
- (BOOL)isEdited;

	/* setParagraphNumber 10 levels (0-9)
	 */
- (void)setParagraphNumberLevel:(int)level style:(int)style 
	startNumber:(int)number prefix:(const char *)prefix 
	suffix:(const char *)suffix attachPrevious:(BOOL)attach;

	/* Returns paragraph number information
	 * Remember to free the information returned
	 */
- (void)paragraphNumberLevel:(int)level style:(int *)style 
	startNumber:(int *)number prefix:(char **)prefix 
	suffix:(char **)suffix attachPrevious:(BOOL *)attach;

	/* Returns the template extension
	 */
- (NSString *)templateExtension;

@end