/*
	Copyright 1995, Anderson Financial Systems Inc.  All Rights Reserved.
	Anderson Financial Systems, Inc.
	909 Sumneytown Pike, Suite 106
	Springhouse, PA 19477
	215 653 0911
 */

@class Border;
#import "WriteUpAPIConstants.h"
#import "Border_Protocol.h"

typedef struct {
    NSFont *font;
    NSString *text;
    NSPoint offset;
    float width;
    NSColor *color;
} WUBullet;

typedef struct {
    float value;
    short type;
	 char leader;
} WUTab;

@protocol StyleAccess

	/* Frees the resource for the style
	 */
- (void)freeResource;

	/*
	 * alters the style's alignment type. See Constants. 
	 */
- (NSTextAlignment)alignment;
- (void)setAlignment:(NSTextAlignment)theMode;
 
	/*
	 * alters the style's indents. These are in points. 
	 */
- (void)setIndents:(float)left:(float)right:(float)first;
- (void)setIndentLeft:(float)value;
- (float)indentLeft;
- (void)setIndentRight:(float)value;
- (float)indentRight;
- (void)setIndentDeltaFirst:(float)value;
- (float)indentDeltaFirst;
 
	/*
	 * alters the style's spacing with regard to other styled paras. These are 
	 * in points. 
	 */
- (void)setSpaceBefore:(float)value;
- (float)spaceBefore;
- (void)setSpaceAfter:(float)value;
- (float)spaceAfter;
- (void)setSpaceBetween:(float)value;
- (float)spaceBetween;

 /*
  * access hypenation flag. 
  */
- (int)hyphenate;
- (void)setHyphenate:(int)val;

	/* accesses the tab list kept by a style. 
	 * See the tab structure above. Also see the Constants to
	 * get the defines for the type of tabs. Values are in POINTS.
	 */
- (void)addTab:(WUTab *)newTab;
- (void)setTabs:(WUTab *)newTabs:(int)numberOfTabs;
- (WUTab *)tabs;
- (int)numTabs;

	/* access style's bullet structure. 
	 */
- (void)makeBullet:(NSString *)text font:aFont offset:(float)X:(float)Y
	color:(NSColor *)aColor;
- (void)removeBullet;
- (void)updateBullet:(NSString *)text font:aFont offset:(float)X:(float)Y
	color:(NSColor *)aColor;
- (void)moveBulletBy:(float)X:(float)Y;
- (void)setBullet:(WUBullet *)newBullet;
- (WUBullet *)bullet;
- (void)setBulletColor:(NSColor *)newColor;
- (NSFont *)bulletFont;
- (NSString *)bulletText;
- (NSPoint)bulletOffset;
- (float)bulletWidth;
- (NSColor *)bulletColor;

	/* Sets Line Spacing.
	 */
- (void)setLineSpacing:(float)newLineSpacing;

	/* F O N T S
	 * See Constants for common fonts. 
	 * fontSize is always in NX_UnitPoint's
	 */
- (void)setFont:(NSString *)fontName size:(float)fontSize;

	/* Sets the style to reflect autonumber level of the document.
	 */
- (void)setAutonumberLevel:(short)aLevel;

	/* Returns the autonumber level of the style.
	 */
- (short)autonumberLevel;

	/* Returns the styles border, it will create one if it does not exist.
	 */
- (Border *)makeBorder;

@end

