/*
 File:       BrowserController.m

 Contains:   Source code for the Controller of the "Browser" window

 Written by: Eric Simenel

 Created:    May 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

#import "BrowserController.h"
#import "ComicsObj.h"

@implementation BrowserController

- (id)init
{
    if (self = [super init])
      {
        // the browser lies in a subproject, so let's get its nib
        if (![NSBundle loadNibNamed:@"Browser" owner:self])
          {
            NSLog(@"Unable to load Browser.nib");
            [self release];
            return nil;
          }
        // I have a lttle less than 1500 titles currently, hence the following capacity...
        array = [[NSMutableArray alloc] initWithCapacity:1500];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(comicsChanged:) name:ComicsDidChangeNotification object:nil];
      }
    return self;
}
- (void)comicsChanged:(NSNotification *)note
{
    [browser loadColumnZero];
}
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:ComicsDidChangeNotification object:nil];
    [array release];
    [super dealloc];
}

- (void)awakeFromNib
{
#if debug
    NSLog(@"in BrowserController:awakeFromNib");
#endif

    // classic initialization, we load the first column
    [browser loadColumnZero];

    // set up the browser the way I like
    [browser setMinColumnWidth:100];
    [browser setMaxVisibleColumns:5];
    [browser setSeparatesColumns:NO];

    // let's show the window
    [[browser window] makeKeyAndOrderFront:nil];
    
#if debug
    NSLog(@"end of BrowserController:awakeFromNib");
#endif
}

// Unlike numberOfRowsInTableView which is called a zillion times, numberOfRowsInColumn is only being called once
// only when the user clicked on a cell in the previous column and the browser wants to display the content of the
// current column. This means that we can (and should) do the whole preparation of the column and computation of its
// number of rows in this method. In this case, the call to sortArray for the 5th column.

- (int)browser:(NSBrowser *)sender numberOfRowsInColumn:(int)column
{
    short brand, series, state, kind;

    // the first 4 colummns have all only 3 cells
    if (column < 4) return 3;

    // if not, let's see what the user has currently selected in the first colums
    brand = [sender selectedRowInColumn:0];
    series = [sender selectedRowInColumn:1];
    state = [sender selectedRowInColumn:2];
    kind = [sender selectedRowInColumn:3];

#if debug
    NSLog(@"column 4, brand= %d, series= %d, state= %d, kind= %d", brand, series, state, kind);
#endif

    // so that we can retrieve the appropriate titles (we don't care for sorting in this browser
    [comicsBase sortArray:array withBrand:brand withSeries:series withKind:kind withState:state withSort:0];
    return [array count];
}

- (void)browser:(NSBrowser *)sender willDisplayCell:(id)cell atRow:(int)row column:(int)column
{
    switch(column)
      {
        case 0: switch(row)
          {
            case 0: [cell setStringValue:@"All Brands"]; break;
            case 1: [cell setStringValue:@"Marvel"]; break;
            case 2: [cell setStringValue:@"DC & Others"]; break;
          } break;
        case 1: switch(row)
          {
            case 0: [cell setStringValue:@"All Series"]; break;
            case 1: [cell setStringValue:@"Long"]; break;
            case 2: [cell setStringValue:@"Mini"]; break;
          } break;
        case 2: switch(row)
          {
            case 0: [cell setStringValue:@"All States"]; break;
            case 1: [cell setStringValue:@"Dead"]; break;
            case 2: [cell setStringValue:@"Live"]; break;
          } break;
        case 3: switch(row)
          {
            case 0: [cell setStringValue:@"All Kinds"]; break;
            case 1: [cell setStringValue:@"Main"]; break;
            case 2: [cell setStringValue:@"Dual"]; break;
          } break;
        case 4:
            [cell setStringValue:[[array objectAtIndex:row] title]];
            break;
      }
    
    // the 5th column is the last
    [cell setLeaf:(column == 4)];

    // this means this cell is ready for display
    [cell setLoaded: YES];
}

@end
