#import <AppKit/AppKit.h>

/*
 File:       OutlineController.h

 Contains:   Header file for the Controller of the "Outline" window

 Written by: Eric Simenel

 Created:    October 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

@interface OutlineController : NSObject
{
    id outline;
    NSMutableArray *nodes;
}

// routines for the outline view
- (id)outlineView:(NSOutlineView *)outlineView child:(int)index ofItem:(id)item;
- (BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable: (id)item;
- (int)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item;
- (id)outlineView:(NSOutlineView *)outlineView objectValueForTableColumn:(NSTableColumn *)tableColumn byItem:(id)item;

// setup is performed here
- (id)init;
- (void)awakeFromNib;

// cleanup is performed here
- (void)dealloc;

@end
