/*
    File:       CalcController.h

    Contains:   xxx

    Written by: Andy Wildenberg

    Created:    Wed 09-Jul-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

// operation consts

enum {kNoOperator, kAddOperator, kSubtractOperator, kMultiplyOperator, kDivideOperator};

@interface CalcController : NSObject
{
    id displayView;
    BOOL enteringNumber;
    BOOL usedDecimalPoint;
    NSDecimalNumber* displayedNumber;
    NSDecimalNumber* enteredNumber;
    SEL nextOperation;
    int lastOperation;
}

- (void)operation:(id)sender;
- (void)clear:(id)sender;
- (void)equals:(id)sender;
- (void)insertDigit:(id)sender;

// pasteboard commands
- (void)cut:(id)sender;
- (void)copy:(id)sender;
- (void)paste:(id)sender;

// internal commands
- (void)beginEditingNumber;
- (void)endEditingNumber;
- (void)decimalPoint:(id)sender;
- (void)awakeFromNib;
- (void)performLastOperation;
- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApplication;

// cleanup commands
-(void)dealloc;
@end
