#ifndef __SD_PageLayout_h
#define __SD_PageLayout_h
//=============================================================================
//
//	Copyright (C) 1996-1997 by Paul S. McCarthy and Eric Sunshine.
//		Written by Paul S. McCarthy and Eric Sunshine.
//			    All Rights Reserved.
//
//	This notice may not be removed from this source code.
//
//	This object is included in the MiscKit by permission from the authors
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//
//=============================================================================
//-----------------------------------------------------------------------------
// "SD_PageLayout.h"
//
//	PCS custom subclass of NeXT's appkit PageLayout panel that adds
//	user controls for:
//
//		Margins
//		Pagination
//		Centering
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SD_PageLayout.h,v 1.1 97/03/21 18:32:17 sunshine Exp $
// $Log:	SD_PageLayout.h,v $
// Revision 1.1  97/03/21  18:32:17  sunshine
// v28: Page layout panel.
// 
//-----------------------------------------------------------------------------
#import	<AppKit/NSPageLayout.h>
@class NSMatrix, NSTextField;

@interface SD_PageLayout : NSPageLayout
    {
    NSWindow*		accessoryWindow;
    NSTextField*	leftMarginField;
    NSTextField*	topMarginField;
    NSTextField*	rightMarginField;
    NSTextField*	bottomMarginField;
    NSMatrix*		centerMatrix;
    NSMatrix*		paginationMatrix;
    }
@end

#endif // __SD_PageLayout_h
