
/*  A Bison parser, made from ./rcfile_y.y
 by  GNU Bison version 1.25
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	DEFAULTS	258
#define	POLL	259
#define	SKIP	260
#define	VIA	261
#define	AKA	262
#define	LOCALDOMAINS	263
#define	PROTOCOL	264
#define	AUTHENTICATE	265
#define	TIMEOUT	266
#define	KPOP	267
#define	SDPS	268
#define	KERBEROS4	269
#define	KERBEROS5	270
#define	KERBEROS	271
#define	ENVELOPE	272
#define	QVIRTUAL	273
#define	USERNAME	274
#define	PASSWORD	275
#define	FOLDER	276
#define	SMTPHOST	277
#define	MDA	278
#define	BSMTP	279
#define	LMTP	280
#define	SMTPADDRESS	281
#define	SPAMRESPONSE	282
#define	PRECONNECT	283
#define	POSTCONNECT	284
#define	LIMIT	285
#define	WARNINGS	286
#define	NETSEC	287
#define	INTERFACE	288
#define	MONITOR	289
#define	PLUGIN	290
#define	PLUGOUT	291
#define	IS	292
#define	HERE	293
#define	THERE	294
#define	TO	295
#define	MAP	296
#define	WILDCARD	297
#define	BATCHLIMIT	298
#define	FETCHLIMIT	299
#define	EXPUNGE	300
#define	PROPERTIES	301
#define	SET	302
#define	LOGFILE	303
#define	DAEMON	304
#define	SYSLOG	305
#define	IDFILE	306
#define	INVISIBLE	307
#define	POSTMASTER	308
#define	BOUNCEMAIL	309
#define	PROTO	310
#define	STRING	311
#define	NUMBER	312
#define	NO	313
#define	KEEP	314
#define	FLUSH	315
#define	FETCHALL	316
#define	REWRITE	317
#define	FORCECR	318
#define	STRIPCR	319
#define	PASS8BITS	320
#define	DROPSTATUS	321
#define	DNS	322
#define	SERVICE	323
#define	PORT	324
#define	UIDL	325
#define	INTERVAL	326
#define	MIMEDECODE	327
#define	CHECKALIAS	328

#line 1 "./rcfile_y.y"

/*
 * rcfile_y.y -- Run control file parser for fetchmail
 *
 * For license terms, see the file COPYING in this directory.
 */

#include "config.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#if defined(HAVE_SYS_WAIT_H)
#include <sys/wait.h>
#endif
#include <sys/stat.h>
#include <errno.h>
#if defined(STDC_HEADERS)
#include <stdlib.h>
#endif
#if defined(HAVE_UNISTD_H)
#include <unistd.h>
#endif
#include <string.h>

#if NET_SECURITY
#include <net/security.h>
#endif /* NET_SECURITY */

#include "fetchmail.h"

/* parser reads these */
char *rcfile;			/* path name of rc file */
struct query cmd_opts;		/* where to put command-line info */

/* parser sets these */
struct query *querylist;	/* head of server list (globally visible) */

int yydebug;			/* in case we didn't generate with -- debug */

static struct query current;	/* current server record */
static int prc_errflag;
static struct hostdata *leadentry;
static flag trailer;

static void record_current(void);
static void user_reset(void);
static void reset_server(const char *name, int skip);

/* using Bison, this arranges that yydebug messages will show actual tokens */
extern char * yytext;
#define YYPRINT(fp, type, val)	fprintf(fp, " = \"%s\"", yytext)

#line 54 "./rcfile_y.y"
typedef union {
  int proto;
  int number;
  char *sval;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		176
#define	YYFLAG		-32768
#define	YYNTBASE	74

#define YYTRANSLATE(x) ((unsigned)(x) <= 328 ? yytranslate[x] : 96)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
    46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
    56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
    66,    67,    68,    69,    70,    71,    72,    73
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     3,     5,     8,    10,    11,    16,    21,    26,
    31,    34,    38,    43,    46,    49,    52,    56,    61,    64,
    67,    69,    70,    73,    75,    78,    80,    83,    86,    89,
    92,    95,    98,   101,   103,   106,   108,   111,   114,   117,
   120,   123,   126,   129,   132,   135,   139,   142,   145,   148,
   151,   154,   157,   160,   162,   165,   168,   170,   172,   174,
   177,   180,   183,   187,   191,   192,   195,   197,   200,   202,
   204,   207,   209,   212,   214,   218,   220,   223,   225,   228,
   230,   233,   237,   240,   244,   247,   251,   254,   257,   260,
   263,   266,   269,   272,   274,   277,   280,   282,   284,   286,
   288,   290,   292,   294,   296,   298,   301,   304,   307,   310,
   313,   316,   319,   322,   325,   328,   331,   334,   337,   340
};

static const short yyrhs[] = {    -1,
    75,     0,    77,     0,    75,    77,     0,    41,     0,     0,
    47,    48,    76,    56,     0,    47,    51,    76,    56,     0,
    47,    49,    76,    57,     0,    47,    53,    76,    56,     0,
    47,    54,     0,    47,    58,    54,     0,    47,    46,    76,
    56,     0,    47,    50,     0,    47,    52,     0,    78,    79,
     0,    78,    79,    83,     0,    78,    79,    83,    82,     0,
     4,    56,     0,     5,    56,     0,     3,     0,     0,    79,
    82,     0,    56,     0,    80,    56,     0,    56,     0,    81,
    56,     0,     7,    80,     0,     6,    56,     0,     8,    81,
     0,     9,    55,     0,     9,    12,     0,     9,    13,     0,
    70,     0,    58,    70,     0,    73,     0,    58,    73,     0,
    68,    56,     0,    69,    57,     0,    71,    57,     0,    10,
    20,     0,    10,    14,     0,    10,    15,     0,    10,    16,
     0,    11,    57,     0,    17,    57,    56,     0,    17,    56,
     0,    18,    56,     0,    32,    56,     0,    33,    56,     0,
    34,    56,     0,    35,    56,     0,    36,    56,     0,    67,
     0,    58,    67,     0,    58,    17,     0,    88,     0,    84,
     0,    85,     0,    84,    85,     0,    86,    87,     0,    19,
    56,     0,    19,    90,    38,     0,    19,    56,    39,     0,
     0,    87,    95,     0,    95,     0,    88,    95,     0,    42,
     0,    90,     0,    90,    42,     0,    91,     0,    90,    91,
     0,    56,     0,    56,    41,    56,     0,    56,     0,    92,
    56,     0,    56,     0,    93,    56,     0,    57,     0,    94,
    57,     0,    40,    89,    38,     0,    40,    89,     0,    37,
    89,    38,     0,    37,    89,     0,    37,    56,    39,     0,
    20,    56,     0,    21,    92,     0,    22,    93,     0,    26,
    56,     0,    27,    94,     0,    23,    56,     0,    24,    56,
     0,    25,     0,    28,    56,     0,    29,    56,     0,    59,
     0,    60,     0,    61,     0,    62,     0,    63,     0,    64,
     0,    65,     0,    66,     0,    72,     0,    58,    59,     0,
    58,    60,     0,    58,    61,     0,    58,    62,     0,    58,
    63,     0,    58,    64,     0,    58,    65,     0,    58,    66,
     0,    58,    72,     0,    30,    57,     0,    31,    57,     0,
    44,    57,     0,    43,    57,     0,    45,    57,     0,    46,
    56,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
    76,    77,    80,    81,    84,    84,    87,    88,    89,    90,
    91,    92,    93,    94,    95,   103,   104,   107,   111,   112,
   113,   116,   117,   120,   121,   124,   125,   128,   129,   130,
   131,   132,   147,   155,   156,   157,   158,   159,   164,   169,
   170,   171,   172,   173,   180,   182,   188,   195,   196,   211,
   218,   225,   226,   227,   228,   229,   232,   233,   236,   237,
   240,   243,   244,   245,   248,   249,   252,   253,   256,   257,
   258,   261,   262,   265,   267,   271,   272,   275,   276,   279,
   285,   293,   294,   295,   296,   298,   299,   300,   301,   302,
   303,   304,   305,   306,   307,   308,   310,   311,   312,   313,
   314,   315,   316,   317,   318,   320,   321,   322,   323,   324,
   325,   326,   327,   328,   330,   331,   332,   333,   334,   336
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","DEFAULTS",
"POLL","SKIP","VIA","AKA","LOCALDOMAINS","PROTOCOL","AUTHENTICATE","TIMEOUT",
"KPOP","SDPS","KERBEROS4","KERBEROS5","KERBEROS","ENVELOPE","QVIRTUAL","USERNAME",
"PASSWORD","FOLDER","SMTPHOST","MDA","BSMTP","LMTP","SMTPADDRESS","SPAMRESPONSE",
"PRECONNECT","POSTCONNECT","LIMIT","WARNINGS","NETSEC","INTERFACE","MONITOR",
"PLUGIN","PLUGOUT","IS","HERE","THERE","TO","MAP","WILDCARD","BATCHLIMIT","FETCHLIMIT",
"EXPUNGE","PROPERTIES","SET","LOGFILE","DAEMON","SYSLOG","IDFILE","INVISIBLE",
"POSTMASTER","BOUNCEMAIL","PROTO","STRING","NUMBER","NO","KEEP","FLUSH","FETCHALL",
"REWRITE","FORCECR","STRIPCR","PASS8BITS","DROPSTATUS","DNS","SERVICE","PORT",
"UIDL","INTERVAL","MIMEDECODE","CHECKALIAS","rcfile","statement_list","optmap",
"statement","define_server","serverspecs","alias_list","domain_list","serv_option",
"userspecs","explicits","explicitdef","userdef","user0opts","user1opts","localnames",
"mapping_list","mapping","folder_list","smtp_list","num_list","user_option", NULL
};
#endif

static const short yyr1[] = {     0,
    74,    74,    75,    75,    76,    76,    77,    77,    77,    77,
    77,    77,    77,    77,    77,    77,    77,    77,    78,    78,
    78,    79,    79,    80,    80,    81,    81,    82,    82,    82,
    82,    82,    82,    82,    82,    82,    82,    82,    82,    82,
    82,    82,    82,    82,    82,    82,    82,    82,    82,    82,
    82,    82,    82,    82,    82,    82,    83,    83,    84,    84,
    85,    86,    86,    86,    87,    87,    88,    88,    89,    89,
    89,    90,    90,    91,    91,    92,    92,    93,    93,    94,
    94,    95,    95,    95,    95,    95,    95,    95,    95,    95,
    95,    95,    95,    95,    95,    95,    95,    95,    95,    95,
    95,    95,    95,    95,    95,    95,    95,    95,    95,    95,
    95,    95,    95,    95,    95,    95,    95,    95,    95,    95
};

static const short yyr2[] = {     0,
     0,     1,     1,     2,     1,     0,     4,     4,     4,     4,
     2,     3,     4,     2,     2,     2,     3,     4,     2,     2,
     1,     0,     2,     1,     2,     1,     2,     2,     2,     2,
     2,     2,     2,     1,     2,     1,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     3,     2,     2,     2,     2,
     2,     2,     2,     1,     2,     2,     1,     1,     1,     2,
     2,     2,     3,     3,     0,     2,     1,     2,     1,     1,
     2,     1,     2,     1,     3,     1,     2,     1,     2,     1,
     2,     3,     2,     3,     2,     3,     2,     2,     2,     2,
     2,     2,     2,     1,     2,     2,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2
};

static const short yydefact[] = {     1,
    21,     0,     0,     0,     2,     3,    22,    19,    20,     6,
     6,     6,    14,     6,    15,     6,    11,     0,     4,    16,
     5,     0,     0,     0,     0,     0,    12,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    94,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    97,    98,    99,   100,   101,   102,   103,   104,    54,     0,
     0,    34,     0,   105,    36,    23,    17,    58,    59,    65,
    57,    67,    13,     7,     9,     8,    10,    29,    24,    28,
    26,    30,    32,    33,    31,    42,    43,    44,    41,    45,
    47,     0,    48,    62,     0,    72,    87,    76,    88,    78,
    89,    92,    93,    90,    80,    91,    95,    96,   115,   116,
    49,    50,    51,    52,    53,    69,    74,    85,    70,    74,
    83,   118,   117,   119,   120,    56,   106,   107,   108,   109,
   110,   111,   112,   113,    55,    35,   114,    37,    38,    39,
    40,     0,    18,    60,    61,     0,    68,    25,    27,    46,
    64,     0,    63,    73,    77,    79,    81,    86,    84,    71,
    82,    66,    75,     0,     0,     0
};

static const short yydefgoto[] = {   174,
     5,    22,     6,     7,    20,    90,    92,    76,    77,    78,
    79,    80,   155,    81,   128,   129,   106,   109,   111,   116,
    82
};

static const short yypact[] = {     4,
-32768,   -45,   -19,   162,     4,-32768,-32768,-32768,-32768,     7,
     7,     7,-32768,     7,-32768,     7,-32768,    18,-32768,    -5,
-32768,    -7,    17,    26,    34,    37,-32768,    38,    40,    41,
    33,   114,    49,   -13,    44,    51,    53,    54,    64,    65,
    67,-32768,    70,    74,    76,    77,    78,    84,    99,   102,
   106,   108,   109,    -9,    -6,   113,   115,   116,   118,    52,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,   119,
   120,-32768,   121,-32768,-32768,-32768,    69,    89,-32768,-32768,
   123,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,   124,
-32768,   134,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,   135,-32768,    43,    14,-32768,-32768,-32768,   136,-32768,
   138,-32768,-32768,-32768,-32768,   122,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,    50,   133,    29,   152,
   166,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,    25,-32768,-32768,   123,   137,-32768,-32768,-32768,-32768,
-32768,   149,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,   176,   206,-32768
};

static const short yypgoto[] = {-32768,
-32768,   145,   202,-32768,-32768,-32768,-32768,   140,-32768,-32768,
   141,-32768,-32768,-32768,   163,   185,   -95,-32768,-32768,-32768,
   -81
};


#define	YYLAST		221


static const short yytable[] = {   157,
    28,    29,    30,    31,    32,    33,     1,     2,     3,   164,
     8,    34,    35,    36,    37,    38,    39,    40,    41,    42,
    43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
    53,    54,   126,   164,    55,   126,     9,    56,    57,    58,
    59,   136,   101,   102,    93,    94,   127,    21,    83,   130,
     4,   163,    60,    61,    62,    63,    64,    65,    66,    67,
    68,    69,    70,    71,    72,    73,    74,    75,   136,   130,
   170,    27,    84,   172,    28,    29,    30,    31,    32,    33,
   -74,   161,    85,   162,   130,    34,    35,    95,   168,    86,
   162,   145,    87,    88,   146,    89,    91,   148,   -74,   103,
    49,    50,    51,    52,    53,   100,   104,    36,   107,   108,
   137,   138,   139,   140,   141,   142,   143,   144,   145,   110,
   112,   146,   113,   147,   148,   114,   152,    96,    97,    98,
   115,   117,   118,    99,   119,    69,    70,    71,    72,    73,
   120,    75,    37,    38,    39,    40,    41,    42,    43,    44,
    45,    46,    47,    48,   121,    23,    24,   122,    25,    54,
    26,   123,    55,   124,   125,    56,    57,    58,    59,   132,
   169,   133,   134,   135,   149,   175,   150,   151,   167,   158,
   156,    61,    62,    63,    64,    65,    66,    67,    68,   159,
   160,   165,   162,   166,    74,   137,   138,   139,   140,   141,
   142,   143,   144,   171,   173,   176,    19,    10,   147,    11,
    12,    13,    14,    15,    16,    17,   153,   131,   154,    18,
   105
};

static const short yycheck[] = {    81,
     6,     7,     8,     9,    10,    11,     3,     4,     5,   105,
    56,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    36,    37,    42,   129,    40,    42,    56,    43,    44,    45,
    46,    17,    56,    57,    12,    13,    56,    41,    56,    56,
    47,    38,    58,    59,    60,    61,    62,    63,    64,    65,
    66,    67,    68,    69,    70,    71,    72,    73,    17,    56,
    42,    54,    56,   155,     6,     7,     8,     9,    10,    11,
    38,    39,    57,    41,    56,    17,    18,    55,    39,    56,
    41,    67,    56,    56,    70,    56,    56,    73,    56,    56,
    32,    33,    34,    35,    36,    57,    56,    19,    56,    56,
    59,    60,    61,    62,    63,    64,    65,    66,    67,    56,
    56,    70,    56,    72,    73,    56,    58,    14,    15,    16,
    57,    56,    56,    20,    57,    67,    68,    69,    70,    71,
    57,    73,    20,    21,    22,    23,    24,    25,    26,    27,
    28,    29,    30,    31,    56,    11,    12,    56,    14,    37,
    16,    56,    40,    56,    56,    43,    44,    45,    46,    57,
    38,    57,    57,    56,    56,     0,    57,    57,    57,    56,
    58,    59,    60,    61,    62,    63,    64,    65,    66,    56,
    56,    56,    41,    56,    72,    59,    60,    61,    62,    63,
    64,    65,    66,    38,    56,     0,     5,    46,    72,    48,
    49,    50,    51,    52,    53,    54,    77,    55,    78,    58,
    36
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 196 "/usr/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 7:
#line 87 "./rcfile_y.y"
{run.logfile = xstrdup(yyvsp[0].sval);;
    break;}
case 8:
#line 88 "./rcfile_y.y"
{run.idfile = xstrdup(yyvsp[0].sval);;
    break;}
case 9:
#line 89 "./rcfile_y.y"
{run.poll_interval = yyvsp[0].number;;
    break;}
case 10:
#line 90 "./rcfile_y.y"
{run.postmaster = xstrdup(yyvsp[0].sval);;
    break;}
case 11:
#line 91 "./rcfile_y.y"
{run.bouncemail = TRUE;;
    break;}
case 12:
#line 92 "./rcfile_y.y"
{run.bouncemail = FALSE;;
    break;}
case 13:
#line 93 "./rcfile_y.y"
{run.properties =xstrdup(yyvsp[0].sval);;
    break;}
case 14:
#line 94 "./rcfile_y.y"
{run.use_syslog = TRUE;;
    break;}
case 15:
#line 95 "./rcfile_y.y"
{run.invisible = TRUE;;
    break;}
case 16:
#line 103 "./rcfile_y.y"
{record_current();;
    break;}
case 18:
#line 108 "./rcfile_y.y"
{yyerror("server option after user options");;
    break;}
case 19:
#line 111 "./rcfile_y.y"
{reset_server(yyvsp[0].sval, FALSE);;
    break;}
case 20:
#line 112 "./rcfile_y.y"
{reset_server(yyvsp[0].sval, TRUE);;
    break;}
case 21:
#line 113 "./rcfile_y.y"
{reset_server("defaults", FALSE);;
    break;}
case 24:
#line 120 "./rcfile_y.y"
{save_str(&current.server.akalist,yyvsp[0].sval,0);;
    break;}
case 25:
#line 121 "./rcfile_y.y"
{save_str(&current.server.akalist,yyvsp[0].sval,0);;
    break;}
case 26:
#line 124 "./rcfile_y.y"
{save_str(&current.server.localdomains,yyvsp[0].sval,0);;
    break;}
case 27:
#line 125 "./rcfile_y.y"
{save_str(&current.server.localdomains,yyvsp[0].sval,0);;
    break;}
case 29:
#line 129 "./rcfile_y.y"
{current.server.via = xstrdup(yyvsp[0].sval);;
    break;}
case 31:
#line 131 "./rcfile_y.y"
{current.server.protocol = yyvsp[0].proto;;
    break;}
case 32:
#line 132 "./rcfile_y.y"
{
					    current.server.protocol = P_POP3;

					    if (current.server.preauthenticate == A_PASSWORD)
#ifdef KERBEROS_V5
						current.server.preauthenticate = A_KERBEROS_V5;
#else
		    				current.server.preauthenticate = A_KERBEROS_V4;
#endif /* KERBEROS_V5 */
#if INET6
					    current.server.service = KPOP_PORT;
#else /* INET6 */
					    current.server.port = KPOP_PORT;
#endif /* INET6 */
					;
    break;}
case 33:
#line 147 "./rcfile_y.y"
{
#ifdef SDPS_ENABLE
					    current.server.protocol = P_POP3;
					    current.server.sdps = TRUE;
#else
					    yyerror("SDPS not enabled.");
#endif /* SDPS_ENABLE */
					;
    break;}
case 34:
#line 155 "./rcfile_y.y"
{current.server.uidl = FLAG_TRUE;;
    break;}
case 35:
#line 156 "./rcfile_y.y"
{current.server.uidl  = FLAG_FALSE;;
    break;}
case 36:
#line 157 "./rcfile_y.y"
{current.server.checkalias = FLAG_TRUE;;
    break;}
case 37:
#line 158 "./rcfile_y.y"
{current.server.checkalias  = FLAG_FALSE;;
    break;}
case 38:
#line 159 "./rcfile_y.y"
{
#if INET6
					current.server.service = yyvsp[0].sval;
#endif /* INET6 */
					;
    break;}
case 39:
#line 164 "./rcfile_y.y"
{
#if !INET6
					current.server.port = yyvsp[0].number;
#endif /* !INET6 */
					;
    break;}
case 40:
#line 169 "./rcfile_y.y"
{current.server.interval = yyvsp[0].number;;
    break;}
case 41:
#line 170 "./rcfile_y.y"
{current.server.preauthenticate = A_PASSWORD;;
    break;}
case 42:
#line 171 "./rcfile_y.y"
{current.server.preauthenticate = A_KERBEROS_V4;;
    break;}
case 43:
#line 172 "./rcfile_y.y"
{current.server.preauthenticate = A_KERBEROS_V5;;
    break;}
case 44:
#line 173 "./rcfile_y.y"
{
#ifdef KERBEROS_V5
		    current.server.preauthenticate = A_KERBEROS_V5;
#else
		    current.server.preauthenticate = A_KERBEROS_V4;
#endif /* KERBEROS_V5 */
		;
    break;}
case 45:
#line 180 "./rcfile_y.y"
{current.server.timeout = yyvsp[0].number;;
    break;}
case 46:
#line 183 "./rcfile_y.y"
{
					    current.server.envelope = 
						xstrdup(yyvsp[0].sval);
					    current.server.envskip = yyvsp[-1].number;
					;
    break;}
case 47:
#line 189 "./rcfile_y.y"
{
					    current.server.envelope = 
						xstrdup(yyvsp[0].sval);
					    current.server.envskip = 0;
					;
    break;}
case 48:
#line 195 "./rcfile_y.y"
{current.server.qvirtual=xstrdup(yyvsp[0].sval);;
    break;}
case 49:
#line 196 "./rcfile_y.y"
{
#ifdef NET_SECURITY
					    void *request;
					    int requestlen;

		    			    if (net_security_strtorequest(yyvsp[0].sval, &request, &requestlen))
						yyerror("invalid security request");
					    else {
						current.server.netsec = xstrdup(yyvsp[0].sval);
					        free(request);
					    }
#else
					    yyerror("network-security support disabled");
#endif /* NET_SECURITY */
					;
    break;}
case 50:
#line 211 "./rcfile_y.y"
{
#if (defined(linux) && !defined(INET6)) || defined(__FreeBSD__)
					interface_parse(yyvsp[0].sval, &current.server);
#else /* (defined(linux) && !defined(INET6)) || defined(__FreeBSD__) */
					fprintf(stderr, "fetchmail: interface option is only supported under Linux and FreeBSD\n");
#endif /* (defined(linux) && !defined(INET6)) || defined(__FreeBSD__) */
					;
    break;}
case 51:
#line 218 "./rcfile_y.y"
{
#if (defined(linux) && !defined(INET6)) || defined(__FreeBSD__)
					current.server.monitor = xstrdup(yyvsp[0].sval);
#else /* (defined(linux) && !defined(INET6)) || defined(__FreeBSD__) */
					fprintf(stderr, "fetchmail: monitor option is only supported under Linux\n");
#endif /* (defined(linux) && !defined(INET6) || defined(__FreeBSD__)) */
					;
    break;}
case 52:
#line 225 "./rcfile_y.y"
{ current.server.plugin = xstrdup(yyvsp[0].sval); ;
    break;}
case 53:
#line 226 "./rcfile_y.y"
{ current.server.plugout = xstrdup(yyvsp[0].sval); ;
    break;}
case 54:
#line 227 "./rcfile_y.y"
{current.server.dns = FLAG_TRUE;;
    break;}
case 55:
#line 228 "./rcfile_y.y"
{current.server.dns = FLAG_FALSE;;
    break;}
case 56:
#line 229 "./rcfile_y.y"
{current.server.envelope = STRING_DISABLED;;
    break;}
case 57:
#line 232 "./rcfile_y.y"
{record_current(); user_reset();;
    break;}
case 59:
#line 236 "./rcfile_y.y"
{record_current(); user_reset();;
    break;}
case 60:
#line 237 "./rcfile_y.y"
{record_current(); user_reset();;
    break;}
case 62:
#line 243 "./rcfile_y.y"
{current.remotename = xstrdup(yyvsp[0].sval);;
    break;}
case 64:
#line 245 "./rcfile_y.y"
{current.remotename = xstrdup(yyvsp[-1].sval);;
    break;}
case 69:
#line 256 "./rcfile_y.y"
{current.wildcard =  TRUE;;
    break;}
case 70:
#line 257 "./rcfile_y.y"
{current.wildcard =  FALSE;;
    break;}
case 71:
#line 258 "./rcfile_y.y"
{current.wildcard =  TRUE;;
    break;}
case 74:
#line 266 "./rcfile_y.y"
{save_str_pair(&current.localnames, yyvsp[0].sval, NULL);;
    break;}
case 75:
#line 268 "./rcfile_y.y"
{save_str_pair(&current.localnames, yyvsp[-2].sval, yyvsp[0].sval);;
    break;}
case 76:
#line 271 "./rcfile_y.y"
{save_str(&current.mailboxes,yyvsp[0].sval,0);;
    break;}
case 77:
#line 272 "./rcfile_y.y"
{save_str(&current.mailboxes,yyvsp[0].sval,0);;
    break;}
case 78:
#line 275 "./rcfile_y.y"
{save_str(&current.smtphunt, yyvsp[0].sval,TRUE);;
    break;}
case 79:
#line 276 "./rcfile_y.y"
{save_str(&current.smtphunt, yyvsp[0].sval,TRUE);;
    break;}
case 80:
#line 280 "./rcfile_y.y"
{
			    struct idlist *id;
			    id=save_str(&current.antispam,STRING_DUMMY,0);
			    id->val.status.num = yyvsp[0].number;
			;
    break;}
case 81:
#line 286 "./rcfile_y.y"
{
			    struct idlist *id;
			    id=save_str(&current.antispam,STRING_DUMMY,0);
			    id->val.status.num = yyvsp[0].number;
			;
    break;}
case 86:
#line 298 "./rcfile_y.y"
{current.remotename  = xstrdup(yyvsp[-1].sval);;
    break;}
case 87:
#line 299 "./rcfile_y.y"
{current.password    = xstrdup(yyvsp[0].sval);;
    break;}
case 90:
#line 302 "./rcfile_y.y"
{current.smtpaddress = xstrdup(yyvsp[0].sval);;
    break;}
case 92:
#line 304 "./rcfile_y.y"
{current.mda         = xstrdup(yyvsp[0].sval);;
    break;}
case 93:
#line 305 "./rcfile_y.y"
{current.bsmtp       = xstrdup(yyvsp[0].sval);;
    break;}
case 94:
#line 306 "./rcfile_y.y"
{current.listener    = LMTP_MODE;;
    break;}
case 95:
#line 307 "./rcfile_y.y"
{current.preconnect  = xstrdup(yyvsp[0].sval);;
    break;}
case 96:
#line 308 "./rcfile_y.y"
{current.postconnect = xstrdup(yyvsp[0].sval);;
    break;}
case 97:
#line 310 "./rcfile_y.y"
{current.keep        = FLAG_TRUE;;
    break;}
case 98:
#line 311 "./rcfile_y.y"
{current.flush       = FLAG_TRUE;;
    break;}
case 99:
#line 312 "./rcfile_y.y"
{current.fetchall    = FLAG_TRUE;;
    break;}
case 100:
#line 313 "./rcfile_y.y"
{current.rewrite     = FLAG_TRUE;;
    break;}
case 101:
#line 314 "./rcfile_y.y"
{current.forcecr     = FLAG_TRUE;;
    break;}
case 102:
#line 315 "./rcfile_y.y"
{current.stripcr     = FLAG_TRUE;;
    break;}
case 103:
#line 316 "./rcfile_y.y"
{current.pass8bits   = FLAG_TRUE;;
    break;}
case 104:
#line 317 "./rcfile_y.y"
{current.dropstatus  = FLAG_TRUE;;
    break;}
case 105:
#line 318 "./rcfile_y.y"
{current.mimedecode  = FLAG_TRUE;;
    break;}
case 106:
#line 320 "./rcfile_y.y"
{current.keep        = FLAG_FALSE;;
    break;}
case 107:
#line 321 "./rcfile_y.y"
{current.flush       = FLAG_FALSE;;
    break;}
case 108:
#line 322 "./rcfile_y.y"
{current.fetchall    = FLAG_FALSE;;
    break;}
case 109:
#line 323 "./rcfile_y.y"
{current.rewrite     = FLAG_FALSE;;
    break;}
case 110:
#line 324 "./rcfile_y.y"
{current.forcecr     = FLAG_FALSE;;
    break;}
case 111:
#line 325 "./rcfile_y.y"
{current.stripcr     = FLAG_FALSE;;
    break;}
case 112:
#line 326 "./rcfile_y.y"
{current.pass8bits   = FLAG_FALSE;;
    break;}
case 113:
#line 327 "./rcfile_y.y"
{current.dropstatus  = FLAG_FALSE;;
    break;}
case 114:
#line 328 "./rcfile_y.y"
{current.mimedecode  = FLAG_FALSE;;
    break;}
case 115:
#line 330 "./rcfile_y.y"
{current.limit       = NUM_VALUE_IN(yyvsp[0].number);;
    break;}
case 116:
#line 331 "./rcfile_y.y"
{current.warnings    = NUM_VALUE_IN(yyvsp[0].number);;
    break;}
case 117:
#line 332 "./rcfile_y.y"
{current.fetchlimit  = NUM_VALUE_IN(yyvsp[0].number);;
    break;}
case 118:
#line 333 "./rcfile_y.y"
{current.batchlimit  = NUM_VALUE_IN(yyvsp[0].number);;
    break;}
case 119:
#line 334 "./rcfile_y.y"
{current.expunge     = NUM_VALUE_IN(yyvsp[0].number);;
    break;}
case 120:
#line 336 "./rcfile_y.y"
{current.properties  = xstrdup(yyvsp[0].sval);;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 498 "/usr/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 338 "./rcfile_y.y"


/* lexer interface */
extern char *rcfile;
extern int prc_lineno;
extern char *yytext;
extern FILE *yyin;

static struct query *hosttail;	/* where to add new elements */

void yyerror (const char *s)
/* report a syntax error */
{
    report_at_line(stderr, 0, rcfile, prc_lineno, "%s at %s", s, 
		   (yytext && yytext[0]) ? yytext : "end of input");
    prc_errflag++;
}

int prc_filecheck(const char *pathname, const flag securecheck)
/* check that a configuration file is secure */
{
#ifndef __EMX__
    struct stat statbuf;

    errno = 0;

    /* special case useful for debugging purposes */
    if (strcmp("/dev/null", pathname) == 0)
	return(PS_SUCCESS);

    /* pass through the special name for stdin */
    if (strcmp("-", pathname) == 0)
	return(PS_SUCCESS);

    /* the run control file must have the same uid as the REAL uid of this 
       process, it must have permissions no greater than 600, and it must not 
       be a symbolic link.  We check these conditions here. */

    if (lstat(pathname, &statbuf) < 0) {
	if (errno == ENOENT) 
	    return(PS_SUCCESS);
	else {
	    report(stderr, "lstat: %s: %s\n", pathname, strerror(errno));
	    return(PS_IOERR);
	}
    }

    if (!securecheck)	return 0;

    if ((statbuf.st_mode & S_IFLNK) == S_IFLNK)
    {
	fprintf(stderr, "File %s must not be a symbolic link.\n", pathname);
	return(PS_AUTHFAIL);
    }

    if (statbuf.st_mode & ~(S_IFREG | S_IREAD | S_IWRITE | S_IEXEC | S_IXGRP))
    {
	fprintf(stderr, "File %s must have no more than -rwx--x--- (0710) permissions.\n", 
		pathname);
	return(PS_AUTHFAIL);
    }

#ifdef HAVE_GETEUID
    if (statbuf.st_uid != geteuid())
#else
    if (statbuf.st_uid != getuid())
#endif /* HAVE_GETEUID */
    {
	fprintf(stderr, "File %s must be owned by you.\n", pathname);
	return(PS_AUTHFAIL);
    }
#endif
    return(PS_SUCCESS);
}

int prc_parse_file (const char *pathname, const flag securecheck)
/* digest the configuration into a linked list of host records */
{
    prc_errflag = 0;
    querylist = hosttail = (struct query *)NULL;

    errno = 0;

    /* Check that the file is secure */
    if ( (prc_errflag = prc_filecheck(pathname, securecheck)) != 0 )
	return(prc_errflag);

    if (errno == ENOENT)
	return(PS_SUCCESS);

    /* Open the configuration file and feed it to the lexer. */
    if (strcmp(pathname, "-") == 0)
	yyin = stdin;
    else if ((yyin = fopen(pathname,"r")) == (FILE *)NULL) {
	report(stderr, "open: %s: %s\n", pathname, strerror(errno));
	return(PS_IOERR);
    }

    yyparse();		/* parse entire file */

    fclose(yyin);

    if (prc_errflag) 
	return(PS_SYNTAX);
    else
	return(PS_SUCCESS);
}

static void reset_server(const char *name, int skip)
/* clear the entire global record and initialize it with a new name */
{
    trailer = FALSE;
    memset(&current,'\0',sizeof(current));
    current.smtp_socket = -1;
    current.server.pollname = xstrdup(name);
    current.server.skip = skip;
}


static void user_reset(void)
/* clear the global current record (user parameters) used by the parser */
{
    struct hostdata save;

    /*
     * Purpose of this code is to initialize the new server block, but
     * preserve whatever server name was previously set.  Also
     * preserve server options unless the command-line explicitly
     * overrides them.
     */
    save = current.server;

    memset(&current, '\0', sizeof(current));
    current.smtp_socket = -1;

    current.server = save;
}

struct query *hostalloc(init)
/* append a host record to the host list */
struct query *init;	/* pointer to block containing initial values */
{
    struct query *node;

    /* allocate new node */
    node = (struct query *) xmalloc(sizeof(struct query));

    /* initialize it */
    if (init)
	memcpy(node, init, sizeof(struct query));
    else
    {
	memset(node, '\0', sizeof(struct query));
	node->smtp_socket = -1;
    }

    /* append to end of list */
    if (hosttail != (struct query *) 0)
	hosttail->next = node;	/* list contains at least one element */
    else
	querylist = node;	/* list is empty */
    hosttail = node;

    if (trailer)
	node->server.lead_server = leadentry;
    else
    {
	node->server.lead_server = NULL;
	leadentry = &node->server;
    }

    return(node);
}

static void record_current(void)
/* register current parameters and append to the host list */
{
    (void) hostalloc(&current);
    trailer = TRUE;
}

/* easier to do this than cope with variations in where the library lives */
int yywrap(void) {return 1;}

/* rcfile_y.y ends here */


