import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.sql.*;

public class InteractiveSQL extends Frame implements ActionListener
{
  public static String itemSave = "Save to file";
  public static String itemExec = "Execute query";
  public static String itemClear = "Clear results";
  public static String itemExit = "Exit";

  Connection databaseConnection;

  TextField command;
  TextArea results;
  TextField status;
  MenuBar theMenu;
  Menu menuFile;
  MenuItem menuSaveToFile;
  MenuItem menuExec;
  MenuItem menuClearResults;
  MenuItem menuExit;

  public static void main(String[] args)
  {
    String user, password, url, driver;

    // Set default values for the command line args
    user     = new String("");
    password = new String("");
    url      = new String("jdbc:openbase://208.28.195.33/Company");
    driver   = new String("openbase.jdbc.ObDriver");
    
    InteractiveSQL theApp = new InteractiveSQL(user, password, url, driver);
  }

  public InteractiveSQL(String user, String password, String url, String driver)
  {
    super("InteractiveSQL");

    this.setBounds(new Rectangle(0, 0, 400, 300));
    this.setLayout(new BorderLayout());
    command = new TextField();
    this.add(command, "North");

    results = new TextArea();
    this.add(results, "Center");

    status = new TextField();
    this.add(status, "South");

    theMenu = new MenuBar();
    menuFile = new Menu("File");

    menuSaveToFile = new MenuItem(itemSave);
    menuExec = new MenuItem(itemExec);
    menuClearResults = new MenuItem(itemClear);
    menuExit = new MenuItem(itemExit);

    menuSaveToFile.addActionListener(this);
    menuExec.addActionListener(this);
    menuClearResults.addActionListener(this);
    menuExit.addActionListener(this);

    menuFile.add(menuSaveToFile);
    menuFile.add(menuExec);
    menuFile.add(menuClearResults);
    menuFile.add(menuExit);
    theMenu.add(menuFile);
    this.setMenuBar(theMenu);
    this.show();

    try
    {
      Class.forName(driver);
      databaseConnection = DriverManager.getConnection(url, user, password);
    }
    catch(ClassNotFoundException cnfe)
    {
      System.out.println(cnfe);
    }
    catch(SQLException sqle)
    {
      System.out.println(sqle);
    }
  }

  public void actionPerformed(ActionEvent ae)
  {
    String cmd = ae.getActionCommand();
    if (cmd.equalsIgnoreCase(itemSave))
      selectedSave();
    else if (cmd.equalsIgnoreCase(itemExec))
      selectedExecute();
    else if (cmd.equalsIgnoreCase(itemExit))
      System.exit(0);
    else if (cmd.equalsIgnoreCase(itemClear))
      results.setText("");
  }

  public void selectedSave()
  {
    // Get a file name, open the file, and write out
    // the contents of the list box
    try
    {
      FileDialog fdlg = new FileDialog(this, "Save results");
      fdlg.show();

      String filename = fdlg.getFile();
      FileWriter fw = new FileWriter(filename);
      PrintWriter pw = new PrintWriter(fw);
      pw.println(results.getText());
      fw.close();
    }
    catch (IOException ioe)
    {
      System.out.println(ioe);
    }
  }

  public void selectedExecute()
  {
    String theQuery = command.getText();
    System.out.println(theQuery);
    int numRows = 0;
    int thisCol;
    
    try
    {
      Statement queryStatement = databaseConnection.createStatement();
      ResultSet theResults = queryStatement.executeQuery(theQuery);
      ResultSetMetaData rsmeta = theResults.getMetaData();

      int numColumns = rsmeta.getColumnCount();
      String resultsText = new String("");

      // if there is anything in the results, we'll append to it.
      if (results.getText().length() > 0)
        resultsText = results.getText().concat("\n");

      while(theResults.next())
      {
        numRows++;
        for(thisCol = 1; thisCol <= numColumns; thisCol++)
		resultsText = resultsText.concat(theResults.getString(thisCol).trim() + "       ");
        resultsText = resultsText.concat("\n");
      }
      results.setText(resultsText);

      status.setFont(new Font("Arial", Font.PLAIN, 10));
      status.setText("Rows returned: " + numRows);
    }
    catch(SQLException sqle)
    {
      status.setFont(new Font("Arial", Font.BOLD, 10));
      status.setText(sqle.toString());
    }
  }
}


