/* Layout.h created by stephane on Fri 06-Feb-1998 */

/* This .h file is an adaption of the Layout.h file which */
/* comes with RDR1. It contains modifications for RDR2, */
/* modifications that I did after a class-dump on */
/* the Preferences.framework. */

#import <AppKit/AppKit.h>

#define MINIATURIZE_ITEM	0x1
#define CLOSE_ITEM			0x2
#define WINDOW_ALL_ITEMS	0x3

#define	CUT_ITEM			0x1
#define COPY_ITEM			0x2
#define PASTE_ITEM			0x4
#define SELECTALL_ITEM		0x8
#define EDIT_ALL_ITEMS		0xf

@interface Layout : NSObject
{
	NSView				*_firstKeyView;
	NSView				*_lastKeyView;
	IBOutlet NSView		*view;
    IBOutlet NSWindow	*window;
	BOOL				_isDirty;
	NSUserDefaults		*_standardUserDefaults;
}

- (void) willUnselect:sender;
- (void) didUnselect:sender;

- (void) willSelect:sender;
- (void) didSelect:sender;

- (void) didHide:sender;
- (void) didUnhide:sender;

- view;

@end

@interface NSApplication(PublicMethods)

- (BOOL)loadNibForLayout:(NSString *)r owner:o;
- appWindow;

// these two methods don't do anything anymore
- (void) enableWindow:(int)flag;
- (void) enableEdit:(int)flag;

@end

@interface NSUserDefaults(PrefsStuff)

// The following two methods do not work!
//+ (NSUserDefaults *) NSGlobalDomainDefaults;
//+ (NSUserDefaults *) NeXT1Defaults;
- (id) initWithDomain:(NSString *)domain;
- (void) removeObjectForKey:(NSString *)defaultName inDomain:(NSString *)domainName;
- (void) setObject:(id)value forKey:(NSString *)key inDomain:(NSString *)domainName;
- (id) objectForKey:(NSString *)defaultName inDomain:(NSString *)domainName;
- (BOOL) boolForKey:(NSString *)defaultName inDomain:(NSString *)domainName;

@end
