
/* FSPopDocTextView.m created by stark on Thu 26-Nov-1998 */
//	stark@easynet.fr

/* Copyright (c)  2000, Baseview Products, Inc.	  */
/* All rights reserved.							  */
/* See the file "License" included with this	  */
/* distribution for licensing details.			  */

/* Modified 02/02/2000, PAJ									*/
/*		- Include functions in popup along with class and	*/
/*		  instance methods.									*/
/* Modified 02/01/2000 by Tom Hageman, tom@basil.icce.rug.nl */
/*		- Fix method detection to be language-independent   */
/*		  (ObjC, Java, Webscript, ...)                      */
/*      - Fix modifier flags check to consider only device- */
/*        INdependent Shift, Alternate, Control, Command.   */
/* Modified 01/13/2000 by Frederic Stark, stark@easynet.fr  */
/*		- Added support for changing key assignments via a  */
/* 		  defaults.                                         */
/* Modified 09/17/1999 by Peter Johnson, peter@baseview.com	*/
/*		- Ported to Mac OS X Server.  This involved			*/
/*		  tweaking the menu and font handling code.			*/
/*		- Added the file name in parenthesis following the	*/
/*		  symbol name. 										*/
/*		- Turned off the "VERBOSE" compile switch			*/
/*		- Added a second kind of popup menu containing all 	*/
/*		  of the symbols for methods in the current file.	*/
/*		  It now works as follows:							*/
/*		  Command click anywhere in the source to get a 	*/
/*		  popup menu with all of symbols (implementation)	*/
/*		  in the current file.  Command-option click		*/
/*		  gets a variation that includes method symbols		*/
/*		  in an interface definition.						*/
/*		  Command-shif click gets the original PopDoc 		*/
/*		  popup menu showing where symbols are defined		*/
/*		  throughout the project.							*/
/*	Modified 1/13/2000, PAJ								    */
/*		- Incorporated support of setting key bindings in 	*/
/*		  defaults					*/
/*		- Added support for Java symbols					*/
/* To Do:													*/
/*		- Add compile switches, where necessary, to compile */
/*		  for different targets, (i.e. MOSX vs. OpentStep)  */



/*	Key bindings I feel more confortable with. Note that ShowLocalSymbolsWithoutInterface is disabled by this preference (fred)
defaults write ProjectBuilder ShowClickedSymbolsMask "( NSCommandKeyMask )"
defaults write ProjectBuilder ShowClickedSymbols "( NSCommandKeyMask )"
defaults write ProjectBuilder ShowLocalSymbolsWithInterfaceMask "( NSAlternateKeyMask )"
defaults write ProjectBuilder ShowLocalSymbolsWithInterface "( NSAlternateKeyMask )"
defaults write ProjectBuilder ShowLocalSymbolsWithoutInterfaceMask "()"
defaults write ProjectBuilder ShowLocalSymbolsWithoutInterface "( NSAlternateKeyMask )"
*/


#import "FSPopDocTextView.h"
#import "PPBAdditions.h"
#import "FSSyncFinder.h"

//#define VERBOSE

//	----------------------------------------------------------------------------

@interface FSPopDocTextView(FSPrivate)

	//	Open file aFilename, select it from aStartLine:aStartChar to aEndLine:aEndChar, scroll sel to visible and bring it to front
+ (void)fsSelectFile:(NSString *)aFilename fromLine:(int)aStartLine :(int)aStartChar toLine:(int)aEndLine :(int)aEndChar;
// PAJ added.  Variations on the original mouseDown to
// show different popup menus.
-(void) showClickedSymbol: (NSEvent *) anEvent;
-(void) showLocalSymbols: (NSEvent *) anEvent withInterface: (BOOL) inShowInterface;
	//	Action for the PopDoc poup
- (void)fsPopDoc:sender;
	//	Build the popup button
- (NSButton *)fsBuildButtonWithArray:(NSArray *)anArray showingFilename: (BOOL) inShowFileName showingAllSymbols: (BOOL) inShowAll showingInterface: (BOOL) inShowInterface;
	//	Display the popup
	// PAJ, changed first param from NSArray to NSButton
	// so this method could be used to display one of several
	// popup menus.
- (void)fsDisplayPopUp:(NSButton *)theButton withEvent:(NSEvent *)anEvent;

@end

//	----------------------------------------------------------------------------

@implementation FSPopDocTextView
@end

//	----------------------------------------------------------------------------

@implementation FSPopDocTextView(FSPrivate)

// opens the file with the given name and selects our symbol
+ (void)fsSelectFile:(NSString *)aFilename fromLine:(int)aStartLine :(int)aStartChar toLine:(int)aEndLine :(int)aEndChar
{		//	Is it just me, or all the documented method fails ?
	NSTextView *theText = [[NSApp delegate] openFileNamed:aFilename];

	if (theText)
	{
		int theStart = [theText positionFromLine:aStartLine]+aStartChar-1;
		int theEnd = [theText positionFromLine:aEndLine]+aEndChar;
		NSRange theRange = NSMakeRange( theStart, theEnd-theStart );
		[theText setSelectedRange:theRange];
		[theText centerSelectionInVisibleArea:self];
		[[theText window] makeKeyAndOrderFront:self];
		[theText showMessage:@"PopDoc"];
	}
	else
		NSBeep();
}

//	----------------------------------------------------------------------------
// show a popup with the files declaring the clicked symbol
-(void) showClickedSymbol: (NSEvent *) anEvent
{
	if ([self isMemberOfClass:NSClassFromString(@"CodeEditText")])
    {
        FSSyncFinder *theFinder = [[[FSSyncFinder alloc] init] autorelease];
        NSPoint theMouse = [self convertPoint:[anEvent locationInWindow] fromView:nil];
        int theGlyphIndex;
        NSMutableCharacterSet *theNonIdentSet = [[[NSMutableCharacterSet alloc] init] autorelease];
        NSRange theRange, theStartRange, theEndRange;
        NSArray *theResult;

            //	Mmmm. One doubleClickAtIndex: could replace the next 15 lines...

            //	Find the glyph under the mouse
        theGlyphIndex = [[self layoutManager] glyphIndexForPoint:theMouse
            inTextContainer:[self textContainer]
            fractionOfDistanceThroughGlyph:NULL];

            //	Construct the set of non ident chars (#### We missed the '_' and '$')
        [theNonIdentSet formUnionWithCharacterSet:[NSCharacterSet alphanumericCharacterSet]];
        [theNonIdentSet invert];

            //	Search for the start of the word
        theRange = NSMakeRange( 0, theGlyphIndex );
        theStartRange = [[self string]
                            rangeOfCharacterFromSet:theNonIdentSet
                            options:NSBackwardsSearch
                            range:theRange];

            //	Search for the end of the word
        theRange = NSMakeRange( theGlyphIndex, [[self string] length]-theGlyphIndex );
        theEndRange = [[self string]
                            rangeOfCharacterFromSet:theNonIdentSet
                            options:0
                            range:theRange];

            //	Build the word range
        theRange = NSMakeRange( NSMaxRange(theStartRange), theEndRange.location-NSMaxRange(theStartRange) );

        if (theRange.length!=0)
        {
			[theFinder fsSetFindString:[[self string] substringWithRange:theRange]];
            [theFinder fsSetCanonicalFile:[[[self delegate] project] canonicalFile]];
            theResult = [theFinder fsSearch];
            if (theResult)
			{
				NSButton *theButton = [self fsBuildButtonWithArray: theResult showingFilename: YES showingAllSymbols: YES showingInterface: YES];
                [self fsDisplayPopUp: theButton withEvent:anEvent];
			}
        }
        else
            NSBeep();
	}
}

//	----------------------------------------------------------------------------
// show a popup menu with the symbols defined (implemention) in the current file
// and optionally symbols declared (interface) as well.
-(void) showLocalSymbols: (NSEvent *) anEvent withInterface: (BOOL) inShowInterface
{
	if ([self isMemberOfClass:NSClassFromString(@"CodeEditText")])
    {
        FSSyncFinder *theFinder = [[[FSSyncFinder alloc] init] autorelease];
        NSArray *theResult;

		id	theSource;

		theSource = [[[NSApp delegate] getDevServer] openSourceFor: [self fileName]];

        {
			[theFinder fsSetFindString: @"*"];
            [theFinder fsSetCanonicalFile:[[[self delegate] project] canonicalFile]];
			[theFinder fsSetDevSource: theSource];
            theResult = [theFinder fsSearch];
            if (theResult)
			{
				NSButton *theButton = [self fsBuildButtonWithArray: theResult showingFilename: NO showingAllSymbols: NO showingInterface: inShowInterface];
                [self fsDisplayPopUp:theButton withEvent:anEvent];
			}
        }
	}
}

//	----------------------------------------------------------------------------
// Action method to handle the popup menu selection
- (void)fsPopDoc:sender
{		//	DevSymbolInfo
	id theSymbol = [[sender selectedCell] representedObject];

		//	DevSource
	id theSource = [theSymbol enclosingSourceView];

		//	Name of file
	NSString *theFilename = [theSource fileName];

		//	Span of def
	FSSpanStruct *theSpan = [theSymbol span];

		//	We load it
	[[self class] fsSelectFile:theFilename fromLine:theSpan->sl :theSpan->sc toLine:theSpan->el :theSpan->ec];
}

//	----------------------------------------------------------------------------
// Builds a popup menu button with various options, given an array of hits
// from a symbol query
- (NSButton *)fsBuildButtonWithArray:(NSArray *)anArray showingFilename: (BOOL) inShowFileName showingAllSymbols: (BOOL) inShowAll showingInterface: (BOOL) inShowInterface
{
	// PAJ, made the popup button static because it was causing PB to die
	// after choosing an item if the popup menu had to scroll.  It sent
	// _backgroundColor to a freed object.
	// I know this is a cheap hack to avoid the problem rather than fix it
	// but, what the hell, it works.
	static NSPopUpButton *theButton = nil;
	NSEnumerator *e = [anArray objectEnumerator];
	id o;
	int theCount = 1;		//	To get all titles differents...

	if (!theButton)
		theButton = [[NSPopUpButton alloc] init];		// will live forever
	else
	{
		[theButton removeAllItems];	// remove items from previous use.
	}

   	//	This test is here because big menus make applicaiton crash...
	if ([anArray count]>100)
	{
		NSLog( @"Menu too big (%d elements)", [anArray count] );
		NSBeep();
		return nil;
	}

	// PAJ, no point in showing a popup menu with no items!
	if ([anArray count] == 0)
	{
		NSBeep();
		return nil;
	}

//	symbolKind:
//		0x01:	variable
//		0x02:	class
//		0x08:	category
//		0x10:	protocol
//		0x20:	function
//		0x40:	enum
//		0x200:	#define
//		0x400:	instance method
//		0x800:	class method

// [TRH] Huh? the above seems incorrect.
// [TRH] Venture a guess wrt these bitmasks...
// [PAJ] agreed.  Below is what it looks like to me...
    
// symbolKind masks: (PAJ)
//		0x02	class
//		0x04	instance method
//		0x08	class method
//		0x10	category
//		0x40	function

#define SYMKIND_IMETHOD_MASK	0x00004
#define SYMKIND_CMETHOD_MASK	0x00008
#define SYMKIND_METHOD_MASK	(SYMKIND_IMETHOD_MASK | SYMKIND_CMETHOD_MASK | 0x40)

//	symbolType>>16:
//	240:	declaration
//	440:	implementation

	while (o=[e nextObject])
	{
		int aSymbolKind;
		aSymbolKind = [o symbolKind];
        
        if (inShowAll || ([o symbolKind] & SYMKIND_METHOD_MASK) != 0)
        {
            BOOL isDeclaration = (([o symbolType]>>16)==0x240);
			if (inShowInterface || !isDeclaration)
            {
                // PAJ added local variables to get file name
                // and add that to the item's title in the popup menu
                NSString	*aSymbolName;
                NSString	*aMenuItemString;
                id 			theSource;

                // PAJ, added NSMenuItemCell and NSFont stuff for port to MOSXS.
                NSMenuItemCell	*theMenuItemCell;
                NSFont		*aCellFont;

                // get the symbol information
                aSymbolName = [o symbolName];
                theSource = [o enclosingSourceView];
                if (inShowFileName)
                {
                    NSString	*aFileName;
                    aFileName = [[theSource fileName] lastPathComponent];
                    aMenuItemString = [NSString stringWithFormat:@"%d: %@ (%@)", theCount, aSymbolName, aFileName];
                }
                else
                    aMenuItemString = [NSString stringWithFormat:@"%d: %@", theCount, aSymbolName];

            // add the new menu item
                [theButton addItemWithTitle: aMenuItemString];
                [[theButton lastItem] setRepresentedObject:o];

                // set the font for the new item
                // italics if it is in a '.h' file
                aCellFont = [NSFont userFontOfSize:10];
                if (isDeclaration)
                    aCellFont = [[NSFontManager sharedFontManager] convertFont: aCellFont toHaveTrait:NSItalicFontMask];
                theMenuItemCell = [[[theButton menu] menuRepresentation] menuItemCellForItemAtIndex: [theButton indexOfItem: [theButton lastItem]]];
                [theMenuItemCell setFont: aCellFont];

                theCount++;
            }
		}
	}

	[theButton sizeToFit];
	{
		// PAJ, adjust the width of the button
		// so that it is small enough to be covered
		// by the menu.  This may only be a problem
		// on MOSXS.
		NSRect	aFrame = [theButton frame];
		aFrame.size.width = 2;
		aFrame.size.height = 2;
		[theButton setFrameSize: aFrame.size];
	}
	[theButton setTarget:self];
	[theButton setAction:@selector(fsPopDoc:)];

#ifdef VERBOSE
	if ([[theButton itemArray] count]!=[anArray count])
		NSLog( @"**** Menu of %d items for %d items", [[theButton itemArray] count], [anArray count] );
#endif

	return theButton;
}

//	----------------------------------------------------------------------------
// displays the appropriate popup menu for the mouse event
- (void) fsDisplayPopUp: (NSButton *) theButton withEvent: (NSEvent *)anEvent
{
	NSPoint thePoint = [self convertPoint:[anEvent locationInWindow] fromView:nil];
	NSRect theButtonFrame;

		//	If no button, the search did not returned anything considered meaningfull
	if (!theButton)
	{	NSBeep();
		return ;
	}

		//	Frame for the button
	theButtonFrame = NSMakeRect( thePoint.x-1, thePoint.y-1, NSWidth([theButton bounds]), NSHeight([theButton bounds]) );

	[theButton setFrame:theButtonFrame];
	[self addSubview:theButton];

	[theButton mouseDown:anEvent];
	[theButton removeFromSuperview];
}

@end

//	----------------------------------------------------------------------------

@implementation FSPopDocTextView(NSTextView_Overrides)

+ (void)initialize
{
    [[NSUserDefaults standardUserDefaults] registerDefaults:
        	[NSDictionary dictionaryWithObjectsAndKeys:
			[NSArray arrayWithObjects: @"NSCommandKeyMask", @"NSShiftKeyMask", nil], @"ShowClickedSymbolsMask",
			[NSArray arrayWithObjects: @"NSCommandKeyMask", @"NSAlternateKeyMask", nil], @"ShowLocalSymbolsWithInterfaceMask",
			[NSArray arrayWithObjects: @"NSCommandKeyMask", nil], @"ShowLocalSymbolsWithoutInterfaceMask",
		nil]
        ];
}

//	----------------------------------------------------------------------------

static int FSModiferMaskFromStrings( NSArray *anArray )
{
	int theMask = 0;
	NSEnumerator *e = [anArray objectEnumerator];
	NSString *o;

	static NSDictionary *sDict;
	if (!sDict)
		sDict = [[NSDictionary dictionaryWithObjectsAndKeys:
			[NSNumber numberWithInt:NSAlphaShiftKeyMask], @"NSAlphaShiftKeyMask",
			[NSNumber numberWithInt:NSShiftKeyMask], @"NSShiftKeyMask",
			[NSNumber numberWithInt:NSControlKeyMask], @"NSControlKeyMask",
			[NSNumber numberWithInt:NSAlternateKeyMask], @"NSAlternateKeyMask",
			[NSNumber numberWithInt:NSCommandKeyMask], @"NSCommandKeyMask",
			[NSNumber numberWithInt:NSNumericPadKeyMask], @"NSNumericPadKeyMask",
			[NSNumber numberWithInt:NSHelpKeyMask], @"NSHelpKeyMask",
			[NSNumber numberWithInt:NSFunctionKeyMask], @"NSFunctionKeyMask",
			nil] retain];

	if (!anArray)
	{		//	Too late to give user meaningfull info. At least we log an error...
		NSLog( @"**** PopNav PB bundle error. Default is not an array" );
		return -1;
	}

	while (o=[e nextObject])
	{
        NSNumber *n = [sDict objectForKey:o];
		if (!n)
			NSLog( @"PopNav PB bundle: [%@] is an unknown mask. Ignored" );
		theMask |= [n intValue];
	}

	return theMask;
}

//	----------------------------------------------------------------------------

//	Looks in user default the modifier key binding for this action string
- (BOOL)_fsCheckEvent:(NSEvent *)anEvent forAction:(NSString *)anAction
{
    int neededModifiers = FSModiferMaskFromStrings([[NSUserDefaults standardUserDefaults] arrayForKey: anAction]);

//	As Tom Hageman explains:
//	I meant it to workaround the following peculiarities:
//
//	- the first 16 bits are used as device-dependent flags. For  
//	instance, when the Shift key is depressed, not only is the  
//	NSShiftKeyMask bit set, but it may (or may not) also be accompanied  
//	by a left- or right-shift flag bit in the device-dependent part. (on  
//	Mac OS X Server it is, don't know about YB/NT.)  These  
//	device-dependent bits interfere with the original equality test (and  
//	are undocumented except in some obscure header files from the NeXT  
//	era, of course...)
//
//	on MacOS X Server (using an ADB keyboard at least), when Shift is  
//	depressed, the (device-independent) NSAlphaShiftKeyMask is also set.

//	int actualModifiers = [anEvent modifierFlags];
    int actualModifiers = [anEvent modifierFlags] & (NSShiftKeyMask|NSAlternateKeyMask|NSControlKeyMask|NSCommandKeyMask);
    
    if (neededModifiers)
        return (actualModifiers == neededModifiers);

    return NO;
}

//	----------------------------------------------------------------------------

// determines if a popup menu button needs to be built and displayed
// and either displays the menu or lets super handle it
- (void)mouseDown:(NSEvent *)anEvent
{	BOOL afHandled = NO;

	if ([self isMemberOfClass:NSClassFromString(@"CodeEditText")])
	{
		if ([self _fsCheckEvent:anEvent forAction:@"ShowClickedSymbolsMask"])
		{
            [self showClickedSymbol:anEvent];
			afHandled = YES;
		}
		else if ([self _fsCheckEvent:anEvent forAction:@"ShowLocalSymbolsWithInterfaceMask"])
		{
            [self showLocalSymbols:anEvent withInterface: YES];
			afHandled = YES;
		}
		else if ([self _fsCheckEvent:anEvent forAction:@"ShowLocalSymbolsWithoutInterfaceMask"])
		{
            [self showLocalSymbols:anEvent withInterface: NO];
			afHandled = YES;
		}
	}

	if (!afHandled)
		[super mouseDown:anEvent];
}

@end

//	Avoir un DevProject serait sympa
//	projectForFile:
//	editorForFile:

/*
* NSApp -> delegate
	EditManager -> projectForFile:
		PBProject
	EditManager -> editorForFile:
		Editor

* self -> delegate
	FileEditor -> project
		PBProject

*/