#import "ADSlave.h"
#import  <Foundation/NSAutoreleasePool.h>
#import "../NSStringAppended.h"
#import "../ADController.h"
#import "../TVController.h"
#import "../BundleLoader.h"
#import "../BackgCtr.h"
#import "../ToyWin.h"
#import "../common.h"

#define  WinBufSIZE	4

static id windowBuffer[WinBufSIZE];
static int	wbp = 0;

@implementation ADSlave

- init:sender with:controller dir:(NSString *)path
{
	adCtrl = sender;
	tvCtrl = controller;
	backCtrl = nil;
	directory = [[NSString alloc] initWithString:path];
	return self;
}

- (void)dealloc
{
	[directory release];
	[backCtrl release];
	[super dealloc];
}

- (void)cancelFullScreen
{
	[backCtrl cleanBackground:self];
}

/* Local Method */
- doNextImage: sender
{
	NSString *fname, *nextf;
	id	tw, oldtw;
	int	method;

	if ((nextf = [adCtrl nextFilename]) == nil)
		return nil;
	fname = [directory newStringByAppendingPathComponent: nextf];

	if ((method = [adCtrl fullscreenMethod]) < 0) {
		BOOL	fixpos, oldflag = NO;
		if ([tvCtrl isOpened:fname]) /* already opened */
			return self;
		fixpos = [adCtrl scanFixPosition];
		if (fixpos)
			oldflag = [ToyWin displayOverKeyWindow: YES];
		tw = [tvCtrl drawFile: fname];
		if (fixpos)
			(void)[ToyWin displayOverKeyWindow: oldflag];
		if (tw) {
			oldtw = windowBuffer[wbp];
			if (tw != oldtw /* coincidental */
			&& oldtw != nil && [tvCtrl checkWindow:oldtw delete:NO]) {
				if (![oldtw hasCounterpart])
					/* has not been miniaturized */
					[[oldtw window] performClose:self];
			}
			windowBuffer[wbp] = tw;
			wbp = (wbp + 1) % WinBufSIZE;
		}
	}else { /* Full Screen */
		NSData *stream;
		if (backCtrl == nil) {
			backCtrl = [BundleLoader loadAndNew: b_BackgCtr];
			[backCtrl setFullScreen: adCtrl];
		}
		if ((stream = [tvCtrl openDataFromFile:fname]) == nil)
			return nil;
		if ([backCtrl setStream: stream with: method] == nil)
			return nil;
	}
	return self;
}

- donext: sender
{
	id	r;
	NSAutoreleasePool *subpool;

	subpool = [[NSAutoreleasePool alloc] init];
	r = [self doNextImage: sender];
	[adCtrl continueLoop:(r != nil)];
	[subpool release];
	return r;
}

- dostep: sender
{
	id	r;
	NSAutoreleasePool *subpool;

	subpool = [[NSAutoreleasePool alloc] init];
	r = [self doNextImage: sender];
	[adCtrl continueLoop:NO];
	[subpool release];
	return r;
}

@end
