#import  "../BackgCtr.h"
#import  <AppKit/NSApplication.h>
#import  <AppKit/NSControl.h>
#import  <AppKit/NSMenuItem.h>
#import  <AppKit/NSWorkspace.h>
#import  <Foundation/NSData.h>
#import  <Foundation/NSBundle.h>	/* LocalizedString */
#import  <Foundation/NSUserDefaults.h>
#import  <stdio.h>
#import  <stdlib.h>
#import  <string.h>
#import  <objc/zone.h>
#import  <bsd/libc.h>
#import  <mach/mach_init.h>
#import  "../TVController.h"
#import  "../ToyWin.h"
#import  "../ToyView.h"
#import  "../common.h"
#import  "../strfunc.h"
#import  "Background.h"
#import  "FullScreenView.h"

@implementation BackgCtr

static NSZone	*backZone;
static int	countOfwin = 0;

- init
{
	backWin = nil;
	backZone = NULL;
	fullscreenCtr = nil;
	return self;
}

- (void)setFullScreen:(id)controller
{
	fullscreenCtr = controller;
}

- (void)cleanBackground:sender
{
	if (backWin == nil)
		return;
	[backWin close];
	/* backWin is released because setReleasedWhenClosed:YES */
	backWin = nil;
	if (--countOfwin == 0) {
		NSRecycleZone(backZone);
		backZone = NULL;
	}
	if (fullscreenCtr == nil) {
		[theController backWinFront:NO];
		[theController backgMenuEnabled:NO];
	}
}

- (void)makeFront:sender
{
	id v;

	if (backWin == nil)
		return;
	if (![(v = [backWin contentView]) isFront])
		[v toFront:self]; 
}

- (void)toggleFront:sender
{
	id v;

	if (backWin == nil)
		return;
	if ([(v = [backWin contentView]) isFront]) /* toggle */
		[v toBehind:self];
	else
		[v toFront:self]; 
}


/* Local Method */
- viewOfBackground
{
	id	view;

	if (backWin)
		return [backWin contentView];
	if (backZone == NULL) {
		backZone = NSCreateZone(vm_page_size, vm_page_size, YES);
		countOfwin = 0;
	}
	if (fullscreenCtr != nil) {
		view = [[FullScreenView allocWithZone:backZone] init];
		[view setController: fullscreenCtr];
	}else
		view = [[Background allocWithZone:backZone] init];
	backWin = [view initWinAttr];
	[backWin setReleasedWhenClosed:YES];
	if (fullscreenCtr != nil)
		[backWin setDelegate: fullscreenCtr];
	++countOfwin;
	return view;
}

- setImage:(NSImage *)backimage hasAlpha:(BOOL)alpha with:(int)method
{
	id	view;
	id	rtn;

	view = [self viewOfBackground];
	rtn = [view setImage: backimage hasAlpha: alpha with: method];
	if (fullscreenCtr)
		[backWin makeKeyWindow];
	else
		[theController backgMenuEnabled:YES];
	[backWin display];
	PSWait();
	return rtn;	/* If nil Err_Memory */
}

- setStream: (NSData *)data with: (int)method
{
	id	view;
	id	rtn;

	view = [self viewOfBackground];
	rtn = [view setStream: data with: method];
	if (fullscreenCtr)
		[backWin makeKeyWindow];
	else
		[theController backgMenuEnabled:YES];
	[backWin display];
	PSWait();
	return rtn;	/* If nil Err_Memory */
}

@end
