#import "FullScreenView.h"
#import <AppKit/psopsOpenStep.h>
#import <AppKit/NSApplication.h>
#import <AppKit/NSWindow.h>
#import <AppKit/NSImage.h>
#import <AppKit/NSControl.h>
#import <AppKit/NSScreen.h>
#import <AppKit/NSColor.h>
#import <AppKit/NSEvent.h>
#import <Foundation/NSData.h>
#import "../PSsplat.h"
#import "../backgops.h"
#import "../PrefControl.h"

#define CursorImgR @"CRightArrow.tiff"
#define CursorImgL @"CLeftArrow.tiff"
#define CursorImgP @"CPause.tiff"

static NSCursor *CursorR = nil;
static NSCursor *CursorL = nil;
static NSCursor *CursorP = nil;
static NSRect	rectL, rectP;

@implementation FullScreenView

+ (void)initialize
{
	NSPoint spot;

	spot.x = 7.0;
	spot.y = 7.0;
	CursorR = [NSCursor alloc];
	CursorL = [NSCursor alloc];
	CursorP = [NSCursor alloc];
#if 0	/* Not Implemented yet...? */
        [xCursor initWithImage: [NSImage imageNamed:CrossCursor]];
	[xCursor setHotSpot:spot];
#else
	[CursorR initWithImage: [NSImage imageNamed:CursorImgR] hotSpot:spot];
	[CursorL initWithImage: [NSImage imageNamed:CursorImgL] hotSpot:spot];
	[CursorP initWithImage: [NSImage imageNamed:CursorImgP] hotSpot:spot];
#endif
	rectL.origin.x = rectL.origin.y = 0;
	rectL.size.width = screenRect.size.width / 3.0;
	rectL.size.height = screenRect.size.height;
	rectP.origin.x = screenRect.size.width * 5.0 / 6.0;
	rectP.origin.y = screenRect.size.height * 5.0 / 6.0;
	rectP.size.width = screenRect.size.width - rectP.origin.x;
	rectP.size.height = screenRect.size.height -rectP.origin.y;
}

- (id)init
{
	[super init];
	controller = nil;
	isfront = YES;
	return self;
}

- (NSWindow *)initWinAttr
{
	NSWindow *win = [self initFrameWindow: NSTitledWindowMask];
	/* NSTitledWindowMask is needed to be a key-window */
	[win setLevel: WLevel_Front];
	[win orderWindow:NSWindowAbove relativeTo:0];
	return win;
}

- (void)resetCursorRects
{
	[self addCursorRect:screenRect cursor:CursorR];
	[self addCursorRect:rectL cursor:CursorL];
	[self addCursorRect:rectP cursor:CursorP];
}

- (void)setController:(id <PlayControl>)obj
{
	controller = obj;
}

- (void)mouseDown:(NSEvent *)event
{
	NSPoint	p;
	int	dmy;

	if ([event type] != NSLeftMouseDown)
		return;
	dmy = [event clickCount];	/* prevent error multi-clicking */
	p = [event locationInWindow];
	p = [self convertPoint:p fromView:nil]; /* View based point */
	if (NSMouseInRect(p, rectL, NO))
		[controller backPush:self];
	else if (NSMouseInRect(p, rectP, NO))
		[controller pausePush:self];
	else
		[controller stepPush:self];
}

@end
