#import "BundleLoader.h"
#import <Foundation/NSBundle.h>

struct _load_tab {
	NSString	*resource;
	NSString	*classname;
};
static struct _load_tab loadtab[BundleNum] = {
	{ @"ImageOpr",	@"ImageOpr" },
	{ @"Reduction",	@"ImageReduce" },
	{ @"Resize",	@"ImageResize" },
	{ @"BackgCtr",	@"BackgCtr" },
	{ @"ADController", @"ADController" },
	{ @"ImageSave",	@"ImageSave" }
};
static Class	classObj[BundleNum];

@implementation BundleLoader

+ (Class)loadClass:(int)classid
{
	NSBundle *bundle;
	NSString *path;

	if (classObj[classid])
		return classObj[classid];

	/* Load "???.bundle" */
	bundle = [NSBundle mainBundle];
	path = [bundle pathForResource:loadtab[classid].resource
			ofType:@"bundle"];
	bundle = [NSBundle bundleWithPath: path];
	if (bundle == nil) /* ERROR */
		return nil;
	classObj[classid] = [bundle classNamed:loadtab[classid].classname];
	return classObj[classid];
}

+ (id)loadAndNew:(int)classid
{
	return [[[self loadClass:classid] alloc] init];
}

@end
