#import "ImageOpCtr.h"
#import "ImageOpr.h"
#import <AppKit/NSApplication.h>
#import <AppKit/NSControl.h>
#import <AppKit/NSPanel.h>
#import <AppKit/NSMenuItem.h>
#import <AppKit/NSPopUpButton.h>
#import <AppKit/NSTextField.h>
#import <AppKit/NSMatrix.h>
#import <Foundation/NSString.h>
#import <Foundation/NSBundle.h>
#import <Foundation/NSUserDefaults.h>
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import "TVController.h"
#import "ToyWin.h"
#import "ToyWinEPS.h"
#import "ToyView.h"
#import "common.h"
#import "BundleLoader.h"
#import "getpixel.h"
#import "strfunc.h"
#import "ImageOpr.bproj/MonoCtr.h"
#import "ImageOpr.bproj/SmResizeCtr.h"
#import "Reduction.bproj/ImageReduce.h"
#import "Resize.bproj/ImageResize.h"

#define ToolPanelName @"ToolPanel"

@implementation ImageOpCtr

/* Local Method */
- loadBundle
{
	static id classImgOp = nil;

	if (classImgOp && imageOpr)
		return self;
	/* Load "ImageOpr.bundle" */
	classImgOp = [BundleLoader loadClass:b_ImageOpr];
	if (classImgOp == nil) /* ERROR */
		return nil;
	imageOpr = [[classImgOp alloc] init];
	return self;
}

/* Local Method */
- loadNib:(int)op
{
	int	tag = 0;
	id	cview = nil;
	static id currentView;

	if (monoPanel == nil) {
		[NSBundle loadNibNamed:@"ImageOpr.nib" owner:self];
		(void)[toolPanel setFrameUsingName: ToolPanelName];
		currentView = nil;
	}
	if (op == NoOperation && currentView == nil)
		op = Monochrome;
	switch (op) {
	case NoOperation:
		cview = currentView;
		break;
	case Rotation:
	case SmoothRotation:
		cview = [rotatePanel contentView];
		tag = 0;
		break;
	case Monochrome:
	case BiLevel:
	case Brightness:
		cview = [monoPanel contentView];
		tag = 1;
		break;
	case SmoothResize:
	case SimpleResize:
		cview = [resizePanel contentView];
		tag = 2;
		break;
	case Reduction:
		cview = [reducePanel contentView];
		tag = 3;
		break;
	case ColorTone:
		cview = [clrTonePanel contentView];
		tag = 4;
		break;
	case Enhance:
	case Emboss:
	case Contour:
		cview = [enhancePanel contentView];
		tag = 5;
		break;
	case ColorChange:
		cview = [clrChangePanel contentView];
		tag = 6;
		break;
	case RandomPttn:
		cview = [randomPanel contentView];
		tag = 7;
		break;
	case SoftFrame:
		cview = [sframePanel contentView];
		tag = 8;
		break;
	case Posterize:
		cview = [posterizePanel contentView];
		tag = 9;
		break;
	default:
		return self;
	}
	if (currentView != cview) {
		if (currentView == nil)
			[toolView addSubview:cview];
		else {
			[currentView retain];
			[toolView replaceSubview:currentView with:cview];
		}
		currentView = cview;
		[cview viewWillMoveToWindow:toolPanel];
		[toolButton selectItemAtIndex:tag];
		[toolPanel display];
	}
	[toolPanel makeKeyAndOrderFront:self];
	[toolPanel setFloatingPanel:YES];
	return self;
}

static int ops[] = {
	Rotation, Monochrome, SmoothResize, Reduction, ColorTone,
	Enhance, ColorChange, RandomPttn, SoftFrame, Posterize
};

- (void)loadNewTool:sender
{
#ifdef __APPLE__
	[self loadNib: ops[ [sender tag] ]];
#else
	[self loadNib: ops[ [sender selectedTag] ]];
#endif
}

- (void)activateToolPanel:sender
{
	int tag = [sender tag];
	[self loadBundle];
	[self loadNib: ops[tag]]; 
}

- (void)forwardInvocation:(NSInvocation *)anInvocation
{
	[self loadBundle];
	if ([imageOpr respondsToSelector:[anInvocation selector]])
		[anInvocation invokeWithTarget:imageOpr];
	else
		[self doesNotRecognizeSelector:[anInvocation selector]];
}

- (id)imageOperator
{
	[self loadBundle];
	return imageOpr;
}

- (void)saveData
{
	[toolPanel saveFrameUsingName: ToolPanelName];
}

- (void)rotateByAngle:sender
{
	static int tagAngles[] = { 0, 90, 270, 180 };
	int tag;

	[self loadBundle];
	tag = [sender tag];
	if (tag == 0) {
		[self loadNib: Rotation];
		return;
	}
	[imageOpr doRotateFlipClip:Rotation to:tagAngles[tag]];
}

- (void)flip:sender
{
	static int flipkind[] = { Horizontal, Vertical, Clip, Negative };

	[self loadBundle];
	[imageOpr doRotateFlipClip:flipkind[[sender tag]] to:0];
}

- (void)readyForResize:sender
{
	[self loadBundle];
	[self loadNib: SmoothResize];
}

- (void)newBitmap:sender
{
	id	resize;

	[self loadBundle];
	[self loadNib: SmoothResize];
	resize = [BundleLoader loadAndNew: b_Resize];
	[resize newBitmapWith: 1.0];	/* 100% */
	[resize release];
}

- (void)reduce:sender
{
	id reduce;

	[self loadBundle];
	reduce = [BundleLoader loadAndNew: b_Reduction];
	[reduce reduce:self];
	[reduce release];
}

- (void)posterize:sender
{
	[imageOpr posterizeWith:[posterDiffSlider floatValue]
		and:[posterCtrlSlider floatValue]];
}

- (void)doResize:sender by:(int)op;
{
	int	a, b;
	float	f;
	id	resize;

	resize = [BundleLoader loadAndNew: b_Resize];
	switch (op) {
	case NewBitmap: /* EPS -> Bitmap */
		[sender getFactor:&f];
		[resize newBitmapWith: f];
		break;
	case ResizeEPS:
		[sender getFactor:&f];
		[resize EPSResizeWith: f];
		break;
	case SmoothResize:
		[sender getRatio:&b :&a];
		if (a <= 0)
			break;	/* Error? */
		[resize smoothResizeWith: b : a];
		break;
	case SimpleResize:
		[sender getFactor:&f];
		[resize simpleResizeWith: f];
		break;
	}
	[resize release];
}

- (void)convertCMYKtoRGB:sender
{
	[self loadBundle];
	[imageOpr convertCMYKtoRGB:sender];
}

- (BOOL)validateMenuItem:(NSMenuItem *)aMenuItem
{
	return [theController hasWindow];
}

@end
