#import "ImageOpCtr.h"
#import "ImageOpr.h"
#import <AppKit/NSControl.h>
#import <AppKit/NSPanel.h>
#import <AppKit/NSMenuItem.h>
#import <AppKit/NSTextField.h>
#import <Foundation/NSString.h>
#import "NSStringAppended.h"
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import "TVController.h"
#import "ToyWin.h"
#import "ToyView.h"
#import "common.h"
#import "strfunc.h"

static ToyWin *commWin = nil;


@implementation ImageOpCtr (EditComm)

- (void)editComment:sender
{
	/* No need to care about code used: cString & stringWithCString: */
	int i;
	commonInfo *cinf;
	const char *p;
	char commmsg[MAX_COMMENT];

	if ((commWin = [theController keyWindow]) == nil) {
		NSBeep();
		return;
	}
	cinf = [[commWin toyView] commonInfo];
	sprintf(commmsg, "%s: ",
		[[[commWin filename] lastPathComponent] cString]);
	for (p = cinf->memo, i = 0; p[i] && p[i] != ':'; i++) ;
	strncat(commmsg, p, i);
	[commentMsg setStringValue:[NSString stringWithCString:commmsg]];
	if (p[i] == ':') {
		while (p[++i] == ' ') ;
		[commentText setStringValue:
			[NSString stringWithCString:&p[i]]];
	}else
		[commentText setStringValue:@""];
	[commentPanel makeKeyAndOrderFront:self]; 
}

- (void)writeComment:sender
{
	commonInfo *cinf;
	int i, last;
	char *p;
	const char *q;
	id tv;

	if ([sender selectedTag] == 0) { /* OK */
		if ([theController checkWindow: commWin delete:NO] == nil) {
			NSBeep();
			return;
		}
		cinf = [(tv = [commWin toyView]) commonInfo];
		last = 0;
		for (p = cinf->memo, i = 0; p[i] && p[i] != ':'; i++)
			if (p[i] != ' ') last = i;
		/* Coding of "cString" is EUC currently */
		if ((q =[[commentText stringValue] cString]) != NULL && *q) {
			strcpy(&p[last + 1], " : ");
			comm_cat(p, q);
		}else
			p[last + 1] = 0;
		[tv rewriteComment];
	}
	[commentPanel performClose:self]; 
}

- (void)SJIStoJIS:sender
{
	commonInfo *cinf;
	const unsigned char *p;
	NSString *tmp;

	if ([theController checkWindow: commWin delete:NO] == nil) {
		NSBeep();
		return;
	}
	cinf = [[commWin toyView] commonInfo];
	if ((p = begin_comm(cinf->memo, YES)) == NULL)
		return;
	tmp = [NSString stringWithCStringInSJIS:p];
	p = [tmp cStringInEUC];
	if (strlen(p) >= MAX_COMMENT-1) {
		unsigned char commmsg[MAX_COMMENT * 2];
		strncpy(commmsg, p, MAX_COMMENT-1);
		tmp = [NSString stringWithCString:commmsg];
	}
	[commentText setStringValue:tmp];
}

@end
