
#import  "ColorChangeCtr.h"
#import  <AppKit/NSColorWell.h>
#import  <AppKit/NSColor.h>
#import  "ColorChanger.h"
#import  "../ImageOpCtr.h"
#import  "../ImageOpr.h"
#import  "../common.h"

@implementation ColorChangeCtr

- (void)changeAlpha:sender
{
	NSColorWell *well;

	well = (NSColorWell *)(([sender selectedTag] == 0)
					? origWell : newWell);
	[well setEnabled:![sender state]]; 
}

/* Local Method */
- getfrom:well : alphastat colors:(int *)color
{
	int i;
	float cl[MAXPLANE];

	if ([alphastat state]) {
		for (i = 0; i < 3; i++)
			color[i] = 255;
		color[ALPHA] = AlphaTransp;
	}else {
		id colobj = [[well color]
			colorUsingColorSpaceName: NSCalibratedRGBColorSpace];
		[colobj getRed:&cl[0] green:&cl[1] blue:&cl[2] alpha:NULL];
		for (i = 0; i < 3; i++)
			color[i] = cl[i] * 255;
		color[ALPHA] = AlphaOpaque;
	}
	return self;
}

- (void)doit:sender
{
	int	origclr[MAXPLANE], newclr[MAXPLANE];
	id	she;

	she = [[ColorChanger alloc] init];
	if (she == nil)
		return;

	[self getfrom:origWell : origAlpha colors:origclr];
	[self getfrom:newWell : newAlpha colors:newclr];

	[she setColor:origclr to:newclr
		with:[comparison floatValue] uniform:[uniform state]];
	[she setOutside:[whichside selectedTag]];
	[she createNewImage];
	[she release];
}


@end
