#import "Enhancer.h"
#import <Foundation/NSObject.h>
#import <Foundation/NSBundle.h>	/* LocalizedString */
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import <math.h>
#import "../WaitMessageCtr.h"
#import "../common.h"
#import "../getpixel.h"

@implementation Enhancer

+ (int)opcode
{
	return Enhance;
}

+ (t_weight)weightTabel
{
	static const char enhanceTab[5][5] = {
		{0, 1, 1, 1, 0},
		{1, 2, 3, 2, 1},
		{1, 3, 0, 3, 1},
		{1, 2, 3, 2, 1},
		{0, 1, 1, 1, 0}
	};
	return enhanceTab;
}

static void enhance_sub(int *pix, int *totalw, int *totalv, int cnum, float factor, float bright)
{
	int	n, v;

	for (n = 0; n < cnum; n++) {
		v = totalv[n] / totalw[n] - pix[n];
		pix[n] -= (int)(factor * v + 0.5);
	}
}

+ (f_enhance)enhanceFunc
{
	return enhance_sub;
}

- (id)waitingMessage
{
	return [theWaitMsg messageDisplay:
		NSLocalizedString(@"Enhancing...", Enhancing)];
}

- (void)setFactor:(float)value
{
	factor = value;
}

- (BOOL)makeNewPlane:(unsigned char **)newmap with:(commonInfo *)newinf
{
	int i, j, x, y, ptr;
	int cnum, pnum;
	int elm[MAXPLANE];
	int alp, err;
	t_weight	weight;
	f_enhance	func;

	weight = [isa weightTabel];
	func = [isa enhanceFunc];
	cnum = pnum = cinf->numcolors;
	if (cinf->alpha) alp = pnum++;
	else alp = 0;

	err = allocImage(newmap, cinf->width, cinf->height + 3, 8, pnum);
	if (err)
		return NO;

	resetPixel(map, 0);
	for (y = 0; y < cinf->height; y++) {
		ptr = cinf->width * (y + 3);
		for (x = 0; x < cinf->width; x++) {
			getPixelA(elm);
			for (i = 0; i < cnum; i++)
				newmap[i][ptr] = elm[i];
			if (alp) newmap[alp][ptr] = elm[ALPHA];
			ptr++;
		}
	}
	if (newinf->alpha && !hadAlpha()) {
		newinf->alpha = NO;
		alp = 0;
	}

	for (y = 0; y < cinf->height; y++) {
		int curp, pw, n, w;
		int xlow, xhigh, ylow, yhigh;
		int totalv[MAXPLANE];
		int totalw[MAXPLANE];
		int pix[MAXPLANE];

		ylow = (y > 2) ? -2 : -y;
		if ((yhigh = cinf->height - 1 - y) > 2) yhigh = 2;
		ptr = cinf->width * (y + 3);
		curp = cinf->width * y;
		for (x = 0; x < cinf->width; x++, ptr++, curp++) {
			if (alp) {
				newmap[alp][curp] = w = newmap[alp][ptr];
				if (w == AlphaTransp) {
					for (n = 0; n < cnum; n++)
						newmap[n][curp] = 255;
					continue;
				}
			}
			xlow = (x > 2) ? -2 : -x;
			if ((xhigh = cinf->width - 1 - x) > 2) xhigh = 2;
			for (n = 0; n < cnum; n++) {
				totalv[n] = 0;
				totalw[n] = 0;
				for (i = ylow; i < yhigh; i++) {
				    pw = cinf->width * (y + 3 + i);
				    for (j = xlow; j < xhigh; j++) {
					totalw[n] += w = weight[i+2][j+2];
					if (w)
					    totalv[n] += newmap[n][pw+x+j] * w;
				    }
				}
				pix[n] = newmap[n][ptr];
			}
			func(pix, totalw, totalv, cnum, factor, bright);
			for (n = 0; n < cnum; n++) {
				w = pix[n];
				newmap[n][curp] = (w < 0) ? 0
						: ((w > 255) ? 255 : w);
			}
		}
	}

	return YES;
}

@end
