#import <AppKit/AppKit.h>
#import "../common.h"

@class ToyWin, ToyView;

@interface ImgOperator:NSObject
{
	commonInfo	*cinf;		/* just pointer */
	ToyWin		*parentw;	/* just pointer */
	unsigned char	*map[MAXPLANE];	/* just pointer */
	NSString	*newfname;	/* auto released */
	id		msgtext;	/* just pointer */
}

/* Virtual */
+ (int)opcode;
+ (BOOL)detectParent;

/* Virtual */
- (BOOL)makeNewPlane:(unsigned char **)newmap with:(commonInfo *)newinf;
- (id)waitingMessage;
- (BOOL)checkInfo:(NSString *)filename;
- (commonInfo *)makeNewInfo;
- (void)setupWith:(ToyView *)tv;
/* LOCAL */
- (int)doOperation;
- (int)doEPSOperation;

- (void)createNewImage;

@end
