#import  "MonotoneView.h"
#import  <AppKit/psopsOpenStep.h>
#import  <AppKit/NSImage.h>
#import  "../common.h"


@implementation MonotoneView

/* Overload */
- (id)initWithFrame:(NSRect)frameRect
{
	[super initWithFrame:frameRect];
	cache = [NSImage alloc];
        [cache initWithSize: frameRect.size];
	tone = NULL;
	[self drawCache];
	return self;
}

/* Overload */
- (void)dealloc
{
	if (cache) [cache release];
	[super dealloc];
}

/* Overload */
- (void)drawRect:(NSRect)r
{
	[cache compositeToPoint:(r.origin)
		fromRect:r operation:NSCompositeCopy];
}

- (void)drawCache
{
	int	i;
	float	half, wid, thick, y;

	[cache lockFocus];
	half = (wid = [self frame].size.width) / 2.0;
	thick = [self frame].size.height / 256.0;
	PSsetlinewidth(thick);
	if (tone)
		for (i = 0; i < 256; i++) {
			y = thick * i;
			PSsetgray(i/255.0);
			PSmoveto(0.0, y);
			PSlineto(half, y);
			PSstroke();
			PSsetgray(tone[i]/255.0);
			PSmoveto(half, y);
			PSlineto(wid, y);
			PSstroke();
		}
	else
		for (i = 0; i < 256; i++) {
			y = thick * i;
			PSsetgray(i/255.0);
			PSmoveto(0.0, y);
			PSlineto(wid, y);
			PSstroke();
		}
	[cache unlockFocus]; 
}

- (void)setTone:(unsigned char *)buffer
{
	tone = buffer;
	[self drawCache]; 
}

@end
