#import  "SmResizeCtr.h"
#import  <AppKit/NSControl.h>
#import  <AppKit/NSMatrix.h>
#import  <AppKit/NSButton.h>
#import  <stdio.h>
#import "../TVController.h"
#import "../ToyWin.h"
#import "../ToyView.h"
#import  "../common.h"
#import  "../ImageOpCtr.h"
#import  "../ImageOpr.h"

#define  rs_SMOOTH	0
#define  rs_SAMPLE	1
#define  SliderMAX	118.0
#define  Sld2Val(v)	(((v) - 92.0) / 0.08)
#define  Val2Sld(v)	(((v) * 0.08) + 92.0)

@implementation SmResizeCtr

typedef struct {
	float	r;
	int	b, a;
} ratio_tab;

static const ratio_tab ratioTab[] = {
	{-100.0,  1, 1 },
	{  6.250, 1, 16 },
	{  7.143, 1, 14 },
	{  8.333, 1, 12 },
	{ 10.000, 1, 10 },
	{ 12.500, 1, 8 }, /* 2 & 16 */
	{ 14.286, 2, 14 },
	{ 15.385, 2, 13 },
	{ 16.667, 2, 12 },
	{ 18.750, 3, 16 },
	{ 20.000, 2, 10 },
	{ 22.222, 2, 9 },
	{ 25.000, 2, 8 }, /* 3 & 12 */
	{ 27.273, 3, 11 },
	{ 30.000, 3, 10 },
	{ 33.333, 3, 9 }, /* 4 & 12 */
	{ 37.500, 3, 8 }, /* 6 & 16 */
	{ 40.000, 4, 10 },
	{ 43.750, 7, 16 },
	{ 46.154, 6, 13 },
	{ 50.000, 4, 8 }, /* 5&10, 6&12, 7&14, 8&16 */
	{ 53.333, 8, 15 },
	{ 57.143, 8, 14 },
	{ 60.000, 6, 10 },
	{ 62.500, 5, 8 }, /* 10 & 16 */
	{ 66.667, 6, 9 }, /* 8 & 12 */
	{ 70.000, 7, 10 },
	{ 71.429, 10, 14 },
	{ 75.000, 6, 8 }, /* 12 & 16, 9 & 12 */
	{ 77.778, 7, 9 },
	{ 80.000, 8, 10 },
	{ 83.333, 10, 12 },
	{ 86.667, 13, 15 },
	{ 90.000, 9, 10 },
	{ 93.750, 15, 16 },
	{ 100.000, 8, 8 },
	{ 106.667, 16, 15 },
	{ 110.000, 11, 10 },
	{ 116.667, 14, 12 },
	{ 120.000, 12, 10 },
	{ 125.000, 10, 8 },
	{ 130.000, 13, 10 },
	{ 133.333, 12, 9 },
	{ 140.000, 14, 10 },
	{ 144.444, 13, 9 },
	{ 150.000, 12, 8 },
	{ 160.000, 16, 10 },
	{ 166.667, 15, 9 },
	{ 175.000, 14, 8 },
	{ 180.000, 9, 5 },
	{ 187.500, 15, 8 },
	{ 200.000, 16, 8 },
	{ 214.286, 15, 7 },
	{ 225.000, 9, 4 },
	{ 233.333, 14, 6 },
	{ 240.000, 12, 5 },
	{ 250.000, 15, 6 },
	{ 260.000, 13, 5 },
	{ 280.000, 14, 5 },
	{ 300.000, 15, 5 },
	{ 320.000, 16, 5 },
	{ 333.333, 10, 3 },
	{ 350.000, 14, 4 },
	{ 375.000, 15, 4 },
	{ 400.000, 16, 4 },
	{ 433.333, 13, 3 },
	{ 450.000, 9, 2 },
	{ 466.667, 14, 3 },
	{ 500.000, 15, 3 },
	{ 533.333, 16, 3 },
	{ 550.000, 11, 2 },
	{ 600.000, 12, 2 },
	{ 650.000, 13, 2 },
	{ 700.000, 14, 2 },
	{ 750.000, 15, 2 },
	{ 800.000, 16, 2 },
	{ 99999.000, 1, 1 }
};

static int get_tabindex(int x, float ratio)
{
	int	i;

	if (ratioTab[x].r == ratio)
		return x;
	if (ratioTab[x].r < ratio) {
		for (i = x; ratioTab[i].r < ratio; i++)
			;
		if (ratioTab[i].r - ratio > ratio - ratioTab[i-1].r)
			--i;
	}else {
		for (i = x; ratioTab[i].r > ratio; i--)
			;
		if (ratio - ratioTab[i].r > ratioTab[i+1].r - ratio)
			++i;
	}
	return i;
}

- init
{
	[super init];
	ratiox = 1;
	svalue = 100.0;
	return self;
}

/* Local Method */
- (void)changeAndSet
{
	NSString *vstr, *rstr;
	int	tag;

	if ([autoButton state]) {
		tag = (svalue < 100.0) ? rs_SMOOTH : rs_SAMPLE;
		[methodButton selectCellWithTag: tag];
	}else
		tag = [methodButton selectedTag];

	ratiox = get_tabindex(ratiox, svalue);
	if (tag == rs_SMOOTH) {
		const ratio_tab *p = &ratioTab[ratiox];
		vstr = [NSString stringWithFormat:@"%5.1f", p->r];
		rstr = [NSString stringWithFormat:@"%d/%d", p->b, p->a];
	}else {
		int w = (int)(svalue * 2);
		svalue = (float)w / 2.0;
		vstr = [NSString stringWithFormat:@"%5.1f", svalue];
		rstr = @"";
	}
	[scaleText setStringValue:vstr];
	[ratioText setStringValue:rstr];
}

- (void)resetValue:sender
{
	svalue = (float)[sender selectedTag];
	[slider setFloatValue: svalue];
	[self changeAndSet];
}

- (void)changeValue:sender
{
	svalue = [slider floatValue];
	if (svalue > 100.0)
		svalue = Sld2Val(svalue);
	[self changeAndSet];
}

/* Local Method */
- (void)setSliderKnob
{
	float	w = (svalue > 100.0) ? Val2Sld(svalue) : svalue;
	if (w > SliderMAX)
		w = SliderMAX;
	[slider setFloatValue: w];
}

- (void)changeText:sender
{
	svalue = [scaleText floatValue];
	[self setSliderKnob];
	[self changeAndSet];
}

- (void)setCurrentScale:sender
{
	ToyWin	*tw;

	if ((tw = [theController keyWindow]) == nil) {
		NSBeep();
		return;
	}
	svalue = [[tw toyView] scaleFactor] * 100.0;
	[self setSliderKnob];
	[self changeAndSet];
}

- (void)getRatio:(int *)b :(int *)a
{
	if ([methodButton selectedTag] == rs_SMOOTH) {
		*b = ratioTab[ratiox].b;
		*a = ratioTab[ratiox].a;
	}else
		*b = *a = 0;
}

- (void)getFactor:(float *)factor
{
	*factor = svalue / 100.0;
}

- (void)setAutoDetect:sender
{
	if ([autoButton state]) {
		[[methodButton cellWithTag:rs_SMOOTH] setEnabled:NO];
		[[methodButton cellWithTag:rs_SAMPLE] setEnabled:NO];
		[self changeAndSet];
	}else {
		[[methodButton cellWithTag:rs_SMOOTH] setEnabled:YES];
		[[methodButton cellWithTag:rs_SAMPLE] setEnabled:YES];
	}
}

- (void)doResize:sender
{
	int tag, kind, op;
	float	f;

	f = svalue - [scaleText floatValue];
	if (f * f > 1.0) {
		svalue = [scaleText floatValue];
		[self setSliderKnob];
		[self changeAndSet];
	}

	tag = [sender selectedTag];
	if (tag == 2) { /* EPS -> Bitmap */
		[imageOpCtr doResize:self by:NewBitmap];
		return;
	}
	kind = [methodButton selectedTag];
	if (svalue == 100.0 || (kind == rs_SMOOTH
			&& ratioTab[ratiox].a == ratioTab[ratiox].b)) {
		NSBeep();
		return;
	}
	if (tag == 1) /* EPS -> EPS */
		op = ResizeEPS;
	else
		op = (kind == rs_SMOOTH) ? SmoothResize : SimpleResize;
	[imageOpCtr doResize:self by:op];
}

@end
