#import "../ImageSave.h"
#import "imagesub.h"
#import <Foundation/NSData.h>
#import <AppKit/NSImage.h>
#import <AppKit/NSSavePanel.h>
#import <AppKit/NSEPSImageRep.h>
#import <AppKit/NSBitmapImageRep.h>
#import <stdio.h>
#import <libc.h>
#import <string.h>
#import <sys/file.h>
#import "../TVController.h"
#import "../ToyView.h"
#import "../ToyWin.h"
#import "../ToyWinEPS.h"
#import "../ColorMap.h"
#import "../AlertShower.h"
#import "../strfunc.h"
#import "../common.h"
#import "save.h"
#import "JpegSavePanel.h"
#import "TiffSavePanel.h"

/* This data is used by ImageSave family */
NSString *saveDir = nil;
NSFileManager *manager;

@implementation ImageSave

+ (void)initialize
{
	manager = [NSFileManager defaultManager];
}


/* NSString Υѥ᥽åɤǤ ".../.dir" + ".tiff" ޤǤʤ */

+ (NSString *)tmpPath:(NSString *)path ext:(const char *)ex
{
	static char	srcfn[MAXFILENAMELEN];
	const char	*p;
	int	i, j;

	strcpy(srcfn, [path cStringInEUC]);
	for (i = j = 0; srcfn[i]; i++)
		if (srcfn[i] == '.') j = i + 1;
	if (j == 0 || srcfn[j-1] == '/')
		srcfn[i] = '.',  j = i + 1;
	for (p = ex; *p; j++, p++)
		srcfn[j] = *p;
	srcfn[j] = 0;
	return [NSString stringWithCStringInEUC:srcfn];
}

+ (NSString *)tmpName:(NSString *)path ext:(const char *)ex
{
	return [ImageSave tmpPath:[path lastPathComponent] ext:ex];
}


- initWithWin: aToyWin
{
	BOOL	isdir = NO;

	[super init];
	toyWin = aToyWin;
	toyView = [toyWin toyView];
	if (!saveDir || ![manager fileExistsAtPath:saveDir isDirectory:&isdir]
		|| !isdir)
		saveDir = [NSHomeDirectory() retain];
	return self;
}


- (NSString *)getSavename: (NSString *)path with:(int)itype
{
	NSString *stmp, *sav = nil;
	const char *ex = NULL;
	static NSSavePanel *savePanel = nil;

	switch (itype) {
	case Type_eps: ex = "eps";  break;
	case Type_bmp: ex = "bmp";  break;
	case Type_gif: ex = "gif";  break;
	case Type_ppm: ex = "pnm";  break;
	case Type_jpg: ex = "jpg";  break;
	case Type_xbm: ex = "xbm";  break;
	case Type_jbg: ex = "bie";  break;
	case Type_png: ex = "png";  break;
	}
	stmp = [ImageSave tmpName:path ext:ex];
	if (!savePanel) {
		savePanel = [NSSavePanel savePanel];
		[savePanel retain];
		[savePanel setTreatsFilePackagesAsDirectories: YES];
	}
	if ([savePanel runModalForDirectory:saveDir file:stmp]) {
		sav = [ImageSave tmpPath:[savePanel filename] ext:ex];
		if (sav == nil || [sav length] == 0)
			return nil;
		if (saveDir) [saveDir release];
		saveDir = [[NSString alloc] initWithString:[savePanel directory]];
	}
	return sav;
}

/* Local Method */
- (NSString *)getSaveTiffName: (NSString *)path jpeg: (BOOL)flag
	compress: (int *)type by: (float *)factor
{
	static TiffSavePanel *savePanel;
	NSString *stmp, *sav = nil;
	const char *ex;

	if (!savePanel) {
		savePanel = (TiffSavePanel *)[TiffSavePanel savePanel];
		[savePanel init: JpegFactor jpeg: flag];
		[savePanel retain];
	}
	ex = [savePanel suffix];
	stmp = [ImageSave tmpName:path ext: ex];
	if ([savePanel runModalForDirectory:saveDir file:stmp]) {
		ex = [savePanel suffix];
		sav = [ImageSave tmpPath:[savePanel filename] ext:ex];
		if (sav == nil || [sav length] == 0)
			return nil;
		if (saveDir) [saveDir release];
		saveDir = [[NSString alloc] initWithString:[savePanel directory]];
		[savePanel compressType:type with:factor];
		// if (*type == NSTIFFCompressionJPEG)
		//	jpegFactor = *factor;
	}
	return sav;
}

/* Local Method */
- (NSString *)getSaveJpegName: (NSString *)path by: (float *)factor : (BOOL *)progress
{
	static JpegSavePanel *savePanel = nil;
	NSString *stmp, *sav = nil;
	const char *ex;

	if (!savePanel) {
		savePanel = (JpegSavePanel *)[JpegSavePanel savePanel];
		[savePanel initFactor: JpegFactor];
		[savePanel retain];
	}
	ex = [savePanel suffix];
	stmp = [ImageSave tmpName:path ext: ex];
	if ([savePanel runModalForDirectory:saveDir file:stmp]) {
		ex = [savePanel suffix];
		sav = [ImageSave tmpPath:[savePanel filename] ext:ex];
		if (sav == nil || [sav length] == 0)
			return NULL;
		if (saveDir) [saveDir release];
		saveDir = [[NSString alloc] initWithString:[savePanel directory]];
		*factor = [savePanel compressFactor];
		*progress = [savePanel progressive];
	}
	return sav;
}

/* Local Method */
- saveEPSAsTiff: sender
{
	NSData *stream;
	NSString *sav;
	int	type;
	float	factor;

	sav = [self getSaveTiffName: [toyWin filename] jpeg: NO
		compress: &type by: &factor];
	if (sav == nil) /* canceled */
		return self;
	/* type = none/lzw */
	stream = [(ToyWinEPS *)toyWin openTiffDataBy:0.0
			compress:(type != NSTIFFCompressionNone)];
	if (stream == NULL) {
		[ErrAlert runAlert:sav : Err_SAVE];
		return self;
	}
	if ([manager isWritableFileAtPath:sav])
		[manager removeFileAtPath:sav handler:nil];
	if ([stream writeToFile:sav atomically:NO] == NO)
		[ErrAlert runAlert:sav : Err_SAVE];
	return self;
}

- (void)saveAsTiff:sender
{
	NSData *stream;
	NSString *sav;
	commonInfo *cinf;
	NSBitmapImageRep *rep;
	BOOL	jflag;
	int	type, err;
	float	factor;

	cinf = [toyView commonInfo];
	if (cinf->type == Type_eps) {
		[self saveEPSAsTiff: sender];
		return;
	}

	rep = (NSBitmapImageRep *)[[toyView image] bestRepresentationForDevice:nil];
	jflag = (cinf->bits > 2  /* && cinf->type != Type_eps */
		&& [rep canBeCompressedUsing: NSTIFFCompressionJPEG]);
	sav = [self getSaveTiffName: [toyWin filename] jpeg: jflag
		compress: &type by: &factor];
	if (sav == nil) /* canceled */
		return;
	if (factor < 1.0) factor = 1.0;
	else if (factor > 255.0) factor = 255.0;
	stream = [rep TIFFRepresentationUsingCompression:type factor:factor];
	if (stream == NULL) {
		[ErrAlert runAlert:sav : Err_SAVE];
		return;
	}
	/* BUG ?  Over Writing LZW on no-compression */
	if ([manager isWritableFileAtPath:sav])
		[manager removeFileAtPath:sav handler:nil];
	err = 0;
	if ([stream writeToFile:sav atomically:NO] == NO)
		err = Err_SAVE;
	// [stream release]; --- stream will autoreleased...
	if (err)
		[ErrAlert runAlert:sav : err];
	else if (type != NSTIFFCompressionJPEG)
		[toyWin resetFilename:sav]; 
}

- (void)saveAsEPS:sender
{
	NSData *stream;
	NSString *sav;
	commonInfo *cinf;
	int	err = 0;

	sav = [self getSavename: [toyWin filename] with:Type_eps];
	if (sav == nil) /* canceled */
		return;
	if ((stream = [toyWin openEPSData]) == NULL) {
		err = Err_MEMORY;
		goto ErrEXIT;
	}
	if ([manager isWritableFileAtPath:sav])
		[manager removeFileAtPath:sav handler:nil];
	if ([stream writeToFile:sav atomically:NO] == NO)
		err = Err_SAVE;
	// [stream release]; --- stream will autoreleased...
ErrEXIT:
	if (err) {
		[ErrAlert runAlert:sav : err];
		return;
	}
	cinf = [toyView commonInfo];
	if (cinf->type == Type_eps)
		[toyWin resetFilename:sav]; 
}


- (void)saveAsType:(int)itype	/* BMP, PPM, JPG, or JBIG */
{
	FILE	*fp;
	NSString *sav;
	commonInfo *cinf;
	ColorMap *colormap = nil;
	unsigned char *map[MAXPLANE];
	float	jpegFactor;
	BOOL	progress = NO;
	int	err = 0;
	const char *ap;

	cinf = [toyView commonInfo];
        if (cinf->cspace == CS_CMYK) {
		[WarnAlert runAlert:[toyWin filename] : Err_SAV_IMPL];
		return;
	}
	if (itype == Type_jbg
	&& (cinf->bits > 2 || cinf->numcolors != 1)) {
		/* ignore alpha, ignore 2 bits gray. Because of EPS... */
		[WarnAlert runAlert:[toyWin filename] : Err_SAV_IMPL];
		return;
	}

	if (itype == Type_jpg)
		sav = [self getSaveJpegName:[toyWin filename]
				by:&jpegFactor : &progress];
	else
		sav = [self getSavename:[toyWin filename] with: itype];
	if (sav == nil) /* canceled */
		return;
	if ((fp = fopen([sav cStringInFS], "w")) == NULL) {
		[ErrAlert runAlert:sav : Err_SAVE];
		return;
	}

	err = [toyWin getBitmap:map info: &cinf];
	if (!err) err = initGetPixel(cinf);
	if (err) goto EXIT;

	ap = [[theController resource] cStringInFS];
	resetPixel(map, 0);
	if (itype == Type_ppm) {
		err = ppmwrite(fp, cinf, map);
	}else if (itype == Type_jpg) {
		int q;
		q = (255.0 - jpegFactor) / 2.55 + 0.5;
		q = (q < 0) ? 0 : ((q > 100) ? 100 : q);
		err = jpgwrite(fp, cinf, ap, q, progress);
		fp = NULL;
	}else if (itype == Type_jbg) {
		err = jbigwrite(fp, cinf, map[0], ap);
		fp = NULL;
	}else { /* bmp only */
		colormap = [[ColorMap alloc] init];
		(void)[self getPalette:colormap
			info:cinf map:map needAlpha:NO err:&err];
		resetPixel(map, 0);
		err = bmpwrite(fp, cinf, ap, map);
		fp = NULL;
	}

EXIT:
	if (fp) (void)fclose(fp);
	if (colormap) [colormap release];
	[toyWin freeTempBitmap];
	if (err) {
		[ErrAlert runAlert:sav : err];
		[manager removeFileAtPath:sav handler:nil];
	}else if (itype != Type_jpg)
		[toyWin resetFilename:sav]; 
}

@end
