#import "../ImageSave.h"
#import "imagesub.h"
#import <Foundation/NSData.h>
#import <AppKit/NSImage.h>
#import <AppKit/NSSavePanel.h>
#import <stdio.h>
#import <libc.h>
#import <string.h>
#import "../TVController.h"
#import "../ToyView.h"
#import "../ToyWin.h"
#import "../ColorMap.h"
#import "../AlertShower.h"
#import "../strfunc.h"
#import "../common.h"
#import "save.h"
#import "GifSavePanel.h"

#define  MANY_COLORS	(-1)	/* must be < 0 */


@implementation ImageSave (SaveGIF)

/* Local Method */
- (NSString *)getSaveIntlName: (NSString *)path
		ext: (const char *)ex interlace: (BOOL *)intp
{
	static GifSavePanel *savePanel = nil;
	NSString	*stmp, *sav = nil;

	stmp = [ImageSave tmpName:path ext:ex];
	if (!savePanel) {
		savePanel = (GifSavePanel *)[GifSavePanel savePanel];
		[savePanel retain];
	}
	[savePanel loadNib];
	if ([savePanel runModalForDirectory:saveDir file:stmp]) {
		sav = [ImageSave tmpPath: [savePanel filename] ext:ex];
		if (sav == nil || [sav length] == 0)
			return nil;
		if (saveDir) [saveDir release];
		saveDir = [[NSString alloc] initWithString:[savePanel directory]];
		*intp = [savePanel interlace];
	}
	return sav;
}


- (int)getPalette:(ColorMap *)colormap info:(commonInfo *)cinf
	map:(unsigned char **)map needAlpha:(BOOL)alflag err:(int *)code
{
	int cnum, err;
	BOOL hasalpha;

	err = 0;
	if (cinf->palette != NULL) {
		if ([colormap allocPalColor] == nil) {
			err = Err_MEMORY;
			goto EXIT;
		}
		cnum = [colormap regPalColorWithAlpha: alflag];
		if (cnum > FIXcount)
			err = MANY_COLORS;
		goto EXIT;
	}

	if ([colormap allocFullColor] == nil) {
		err = Err_MEMORY;
		goto EXIT;
	}
	cnum = alflag
		? [colormap getAllColor:map limit:FIXcount alpha:&hasalpha]
		: [colormap getAllColor:map limit:FIXcount];
	if (hasalpha) ++cnum;
	if (cnum > FIXcount)
		err = MANY_COLORS;
	else {
		(void)[colormap getNormalmap: &cnum];
		cinf->palette = [colormap getPalette];
		cinf->palsteps = cnum;
	}
EXIT:
	if (err) {
		*code = err;
		return 0;
	}
	return cinf->palsteps;
}


- (NSString *)saveAsGif:(NSString *)gifname
{
	NSString *sav, *result = nil;
	commonInfo *cinf;
	ColorMap *colormap = nil;
	unsigned char *map[MAXPLANE];
	int	cnum, err;
	static BOOL	interl = NO;

	cinf = [toyView commonInfo];
        if (cinf->cspace == CS_CMYK) {
		[WarnAlert runAlert:[toyWin filename] : Err_SAV_IMPL];
		return nil;
	}

	if (gifname) /* Called after reduction */
		sav = gifname;
	else {
		sav = [self getSaveIntlName: [toyWin filename]
				ext: "gif" interlace: &interl];
		if (sav == nil) /* canceled */
			return nil;
	}

	if ((err = [toyWin getBitmap:map info: &cinf]) != 0)
		goto EXIT;
	if ((err = initGetPixel(cinf)) != 0)
		goto EXIT;

	colormap = [[ColorMap alloc] init];
	cnum = [self getPalette:colormap
		info:cinf map:map needAlpha:cinf->alpha err:&err];
	if (cnum == 0) {
		NSString *ask, *cancel, *reduce;
		if (err != MANY_COLORS)
			goto EXIT;
		ask = NSLocalizedString(@"Reduction Start", GIF_Reduction);
		cancel = NSLocalizedString(@"Cancel", Stop_SAVE);
		reduce = NSLocalizedString(@"Reduce", BMP_Reduce);
		if (NSRunAlertPanel(@"", ask, reduce, cancel, nil))
			result = sav; /* Save after reduction */
		err = 0;
		goto EXIT;
	}

	if (!err) {
		FILE	*fp;
		int	transp;
		const char *ap;

		transp = (cinf->alpha && cinf->palette) ? cinf->palsteps : -1;
		if ((fp = fopen([sav cStringInFS], "w")) == NULL) {
			[ErrAlert runAlert:sav : Err_SAVE];
			[colormap release];
			[toyWin freeTempBitmap];
			return nil;	// Don't goto EXIT.
		}
		resetPixel(map, 0);
		ap = [[theController resource] cStringInFS];
		gifwrite(fp, cinf, ap, interl);
		/* fp is closed in gifwrite */
		[toyWin resetFilename:sav];
	}

EXIT:
	if (colormap) [colormap release];
	[toyWin freeTempBitmap];
	if (err) {
		[ErrAlert runAlert:sav : err];
		[manager removeFileAtPath:sav handler:nil];
	}
	/* result != nil  -->  This method is called again after Reduction */
	return result;
}


- saveAsPng: sender
{
	commonInfo *cinf;
	commonInfo copyinf;
	FILE	*fp;
	ColorMap *colormap = nil;
	NSString *sav;
	unsigned char *map[MAXPLANE];
	int	err;
	static BOOL	interl = NO;
	const char *ap;

	cinf = [toyView commonInfo];
        if (cinf->cspace == CS_CMYK) {
		[WarnAlert runAlert:[toyWin filename] : Err_SAV_IMPL];
		return NULL;
	}
	if ((sav = [self getSaveIntlName: [toyWin filename]
		ext: "png" interlace: &interl]) == nil) /* canceled */
		return NULL;
	if ((fp = fopen([sav cStringInFS], "w")) == NULL) {
		[ErrAlert runAlert:sav : Err_SAVE];
		return self;
	}
	err = [toyWin getBitmap:map info: &cinf];
	if (!err) err = initGetPixel(cinf);
	if (err) goto EXIT;
	if (cinf->cspace != CS_RGB) { /* Monochrome */
		copyinf = *cinf;
		copyinf.palette = NULL;	/* No need to allocate palette */
		copyinf.palsteps = 0;
		cinf = &copyinf;
	}else {
		colormap = [[ColorMap alloc] init];
		(void) [self getPalette:colormap
			info:cinf map:map needAlpha:YES err:&err];
		err = 0;	/* Error is ignored */
	}
	resetPixel(map, 0);
	ap = [[theController resource] cStringInFS];
	pngwrite(fp, cinf, ap, interl);
	/* fp is closed in pngwrite */
EXIT:
	if (colormap) [colormap release];
	[toyWin freeTempBitmap];
	if (err) {
		[ErrAlert runAlert:sav : err];
		[manager removeFileAtPath:sav handler:nil];
	}else
		[toyWin resetFilename:sav];
	return self;
}

@end
