#import  "JpegSavePanel.h"
#import  <AppKit/NSApplication.h>
#import  <AppKit/NSControl.h>
#import  <AppKit/NSButton.h>
#import  <AppKit/NSMatrix.h>
#import  "../ImageSave.h"

#define  Tag_jpg	0
#define  Tag_jpEg	1


@implementation JpegSavePanel

static BOOL prev = NO;

#define  SqDelta	0.001

static float sqroot(float x) // sqrt() ; low precision
{
	float s, old;

	if (x <= SqDelta)
		return 0.0;
	s = (x > 1.0) ? x : 1.0;
	do {
		old = s;
		s = (x / s + s) / 2.0;
	} while (old - s > SqDelta);
	return old;
}


- initFactor:(float)factor
{
	[self loadNib];
	if (factor > 255.0) factor = 255.0;
	else if (factor < 0.0) factor = 0.0;
	[JPEGtext setIntValue: (int)factor];
	[JPEGslider setFloatValue:sqroot(factor)];
	return self;
}

- (void)loadNib
{
	if ([self accessoryView] == nil) {
		[NSBundle loadNibNamed:@"JpegAccessory.nib" owner:self];
		[self setAccessoryView:[accessory contentView]];
	}
	[progrSW setState:prev]; 
}


- (float)compressFactor
{
	return (float)[JPEGtext intValue];
}


- (BOOL)progressive
{
	return (prev = [progrSW state]);
}

- (void)takeFloatValueFrom:(id)sender
{
	/* 0 -  6 (0 -  36)   step 1
	 *   - 10 (  - 100)   step 2
	 *   - 16 (  - 255)   step 5
	 */
	int n;
	float r = [sender floatValue];
	if (r <= 6.0) n = (int)(r * r);
	else if (r <= 10.0) n = (int)(r * r) & ~1;
	else {
		n = (int)(r * r) / 5 * 5;
		if (n > 255) n = 255;
	}
	[JPEGtext setIntValue:n];
}

- (const char *)suffix
{
	return ([suffixButton selectedTag] == Tag_jpEg) ? "jpeg" : "jpg";
}

/* NOTE: This method uses "_form", which is an instance variable of
   superclass NSSavePanel.  Be careful. */
- (void)changeSuffix: sender
{
	NSString *name;

	name = [_form stringValue];
	if (name == nil || [name length] == 0)
		return;
	name = [ImageSave tmpPath: name ext: [self suffix]];
	[_form setStringValue: name];
}

@end
