#import  "TiffSavePanel.h"
#import  <AppKit/NSApplication.h>
#import  <AppKit/NSControl.h>
#import  <AppKit/NSMatrix.h>
#import  <AppKit/NSImage.h>

#define  Tag_None	0
#define  Tag_LZW	1
#define  Tag_JPEG	2

#define  Tag_tiff	0
#define  Tag_tiF	1

@implementation TiffSavePanel

/* Local Method */
- (void)setJpegEnabled:(BOOL)flag
{
	NSColor *tx = flag ? [NSColor blackColor] : [NSColor grayColor];
	[JPEGslider setEnabled: flag];
	[JPEGtext setTextColor: tx];
}

- init:(float)factor jpeg: (BOOL)flag
{
	[self initFactor: factor];
	JPEGselectable = flag;
	[[compButton cellWithTag:Tag_JPEG] setEnabled:JPEGselectable];
	[self setJpegEnabled:NO];
	return self;
}

- (void)loadNib
{
	if ([self accessoryView] == nil) {
		[NSBundle loadNibNamed:@"TiffAccessory.nib" owner:self];
		[self setAccessoryView:[accessory contentView]];
	} 
}

- (void)compressType:(int *)type with:(float *)factor
{
	*type = NSTIFFCompressionNone;

	*factor = 0.0;
	switch ([compButton selectedTag]) {
	case Tag_None:
		*type = NSTIFFCompressionNone;
		break;
	case Tag_LZW:
		*type = NSTIFFCompressionLZW;
		break;
	case Tag_JPEG:
		*type = NSTIFFCompressionJPEG;
		*factor = (float)[JPEGtext intValue];
		break;
	} 
}

- (void)buttonChanged:sender
{
	if (JPEGselectable)
		[self setJpegEnabled:([compButton selectedTag] == Tag_JPEG)];
}

/* Over write */
- (const char *)suffix
{
	return ([suffixButton selectedTag] == Tag_tiF) ? "tif" : "tiff";
}

@end
