#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>
#import "ColorMap.h"
#import "common.h"


@interface ImageSave:NSObject
{
	id	toyWin;
	id	toyView;
}

+ (void)initialize;
+ (NSString *)tmpPath:(NSString *)path ext:(const char *)ex;
+ (NSString *)tmpName:(NSString *)path ext:(const char *)ex;

- initWithWin: aToyWin;
- (NSString *)getSavename: (NSString *)path with:(int)itype;
- (void)saveAsTiff:sender;
- (void)saveAsEPS:sender;
- (void)saveAsType:(int)itype;

@end


@interface ImageSave (SaveXBM)

- (void)saveAsXBM:sender;

@end

@interface ImageSave (SaveGIF)

- (int)getPalette:(ColorMap *)colormap info:(commonInfo *)cinf
	map:(unsigned char **)map needAlpha:(BOOL)alflag err:(int *)code;
- (NSString *)saveAsGif:(NSString *)gifname;
- saveAsPng: sender;

@end
