#import <AppKit/AppKit.h>
#import <AppKit/NSWindow.h>

enum {
	pos_Automatic	= 0,
	pos_Fix		= 1,
	pos_FixScan	= 2
};

@interface PrefControl:NSObject
{
	id	panel;
	id	pcdBright;
	id	pcdSize;
	id	origSW;
	id	positionSW;
	id	positionPanel;
	id	transSW;
	id	adIntSlider;
	id	winIntSlider;
	id	adIgnoreSW;
	id	timedAltSW;
	id	updateSvcSW;
	id	unixExpertSW;
	id	backgWell;
	id	fscrWell;
	int	pcdBrightValue;
	int	pcdSizeValue;
	BOOL	origSWValue;
	int	winIntervalValue;
	int	adIntervalValue;
	BOOL	adIgnoreDots;
	int	windowPosValue;
	int	transColorValue;
	int	timedAltValue;
	BOOL	updateSvcValue;		/* call NSUpdateDynamicServices() ? */
	BOOL	unixExpertValue;	/* See all Unix files ? */
		/* Because of bug(?) of Preferences of OPENSTEP 4.1. */
	float	backg[2][4];
	NSPoint	topLeftPoint;
}

+ (void)initialize;
- init;
- (void)makeKeyAndOrderFront:(id)sender;
- (void)changeValue:sender;
- (void)changeWell:sender;

- (int)autoDisplayInterval;
- (int)allWinDisplayInterval;
- (BOOL)ignoreDottedFiles;

- (int)windowPosition;
- (NSPoint)topLeftPoint;
- (void)setPosition:(id)sender;
- (void)showPositionPanel:(id)sender;

- (BOOL)isUpdatedServices;
- (void)backgroungColor:(float *)colors front:(BOOL)flag;

/* delegate of NSPanel */
- (void)windowWillClose:(NSNotification *)aNotification;

@end

extern PrefControl *thePreference;
