#import "PrefControl.h"
#import <Foundation/NSUserDefaults.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSBundle.h>	/* LocalizedString */
#import <AppKit/NSColorWell.h>
#import <AppKit/NSColor.h>
#import <AppKit/NSPopUpButton.h>
#import <AppKit/NSScreen.h>
#import "AlertShower.h"
#import "ToyView.h"
#import "ToyWin.h"
#import "ToyWinPCD.h"
#import "ppm.h"
#import "SliderAndTextCtr.h"

#define  OWNER		@"ToyViewer"
#define  pcdSIZE	@"pcdSIZE"
#define  pcdBRIGHT	@"pcdBRIGHT"
#define  adINTERVAL	@"adINTERVAL"
#define  winINTERVAL	@"winINTERVAL"
#define  adIGNOREDOTS	@"adIGNOREDOTS"
#define  originUL	@"originUL"
#define  winPOSITION	@"winPOSITION"
#define  timedALERT	@"timedALERT"
#define  updateSVC	@"updateSVC"
#define  unixExpert	@"NSUnixExpert"
#define  transCOLOR	@"transCOLOR"
#define  topLeftPOINT	@"topLeftPOINT"
#define  FixedXPos	240.0
#ifdef __APPLE__
#define  FixedYPos	22.0
#else
#define  FixedYPos	12.0
#endif

static NSUserDefaults *usrdef = nil;
static NSSize screenSize;
static NSString *winPosKey[] = { @"Auto", @"Fix", @"ScanFix" };
static NSString *backgCOLOR[] =	{ @"backgCOLOR", @"fscreenCOLOR" };


PrefControl *thePreference = NULL;


@implementation PrefControl

+ (void)initialize
{
	usrdef = [NSUserDefaults standardUserDefaults];
	screenSize = [[NSScreen mainScreen] frame].size;
}

/* Local Method */
- (void)getDefColorWells
{
	int i, n;
	NSArray *ar;

	for (n = 0; n < 2; n++) {
		ar = [usrdef arrayForKey:backgCOLOR[n]];
		if (ar == nil || [ar count] < 3) {
			static float defs[2][3] = {
				{ 0.33333, 0.33333, 0.46667 },
				{ 0.0, 0.0, 0.08 }
			};
			for (i = 0; i < 3; i++)
				backg[n][i] = defs[n][i];

		}else {
			for (i = 0; i < 3; i++)
				backg[n][i] = [[ar objectAtIndex: i] intValue] / 255.0;
		}
	}
}

- init
{
	NSString *s;
	const char *p;
	NSArray *ar;

	s = [usrdef stringForKey:pcdSIZE];
	pcdSizeValue = s ? [s intValue] : 1;	/* Base/4 */
	s = [usrdef stringForKey:pcdBRIGHT];
	pcdBrightValue = s ? [s intValue] : 1; /* Normal */
	[ToyWinPCD setBase:pcdSizeValue bright:pcdBrightValue];

	s = [usrdef stringForKey:adINTERVAL];
	adIntervalValue = s ? [s intValue] : 2500; /* 2.5 sec */
	adIgnoreDots = [usrdef boolForKey:adIGNOREDOTS];

	s = [usrdef stringForKey:winINTERVAL];
	winIntervalValue = s ? [s intValue] : 1000; /* 1.0 sec */

	origSWValue = [usrdef boolForKey:originUL];	/* UpperLower */
	(void)[ToyView setOriginUpperLeft: origSWValue];

	windowPosValue = 1;	/* Fix */
	s = [usrdef stringForKey:winPOSITION];
	if (s != nil && (p = [s cString]) != NULL)
		windowPosValue = (*p == 'F') ? 1 : ((*p == 'S') ? 2 : 0);
	(void)[ToyWin displayOverKeyWindow: (windowPosValue == pos_Fix)];
	ar = [usrdef arrayForKey:topLeftPOINT];
	if (ar == nil || [ar count] < 2) {
		topLeftPoint.x = FixedXPos;
		topLeftPoint.y = FixedYPos;
	}else {
		topLeftPoint.x = [[ar objectAtIndex: 0] floatValue];
		topLeftPoint.y = [[ar objectAtIndex: 1] floatValue];
	}

	transColorValue = 0;	/* Black */
	s = [usrdef stringForKey:transCOLOR];
	if (s != nil && (p = [s cString]) != NULL)
		transColorValue = (*p == 'W') ? 1 : 0;
	[ToyView setTransColorBlack:(transColorValue == 0)];
	setGIFWrongIndexBlack(transColorValue == 0);

	ErrAlert = [[AlertShower alloc]
		initWithTitle:NSLocalizedString(@"ERROR", ERROR)];
	WarnAlert = [[AlertShower alloc]
		initWithTitle:NSLocalizedString(@"WARNING", ERROR)];
	timedAltValue = [usrdef boolForKey:timedALERT] ? 1 : 0;
	if (timedAltValue)
		[AlertShower setTimedAlert: YES];

	updateSvcValue = [usrdef boolForKey:updateSVC];
#ifndef __APPLE__
	unixExpertValue = [usrdef boolForKey:unixExpert];
#endif
	[self getDefColorWells];

	thePreference = self;
	return self;
}

- (void)makeKeyAndOrderFront:(id)sender
{
	if (panel == nil) {
		[NSBundle loadNibNamed:@"Preference.nib" owner:self];
		[pcdSize selectItemAtIndex:pcdSizeValue];
		[pcdBright selectCellWithTag:pcdBrightValue];
		[winIntSlider setScale:0.001 andFormat:@"%4.1f"];
		[winIntSlider setIntValue:winIntervalValue];
		[adIntSlider setScale:0.001 andFormat:@"%4.1f"];
		[adIntSlider setIntValue:adIntervalValue];
		[adIgnoreSW setState: adIgnoreDots];
		[origSW selectCellWithTag:(origSWValue ? 1 : 0)];
		[positionSW selectCellWithTag:windowPosValue];
		[transSW selectCellWithTag: transColorValue];
		[timedAltSW setState:timedAltValue];
		[updateSvcSW setState:(updateSvcValue ? 1 : 0)];
#ifndef __APPLE__
		[unixExpertSW setState:(unixExpertValue ? 1 : 0)];
#endif
		[backgWell setColor:
			[NSColor colorWithCalibratedRed:backg[0][0]
			green:backg[0][1] blue:backg[0][2] alpha:1.0]];
		[fscrWell setColor:
			[NSColor colorWithCalibratedRed:backg[1][0]
			green:backg[1][1] blue:backg[1][2] alpha:1.0]];
	}
	[panel makeKeyAndOrderFront:sender];
}

- (void)changeValue:sender
{
	int val;
	BOOL bval, pcdflag;

	pcdflag = NO;
	val = [pcdSize indexOfSelectedItem];
	if (val != pcdSizeValue) {
		pcdflag = YES;
                [usrdef setInteger:(pcdSizeValue = val) forKey:pcdSIZE];
	}
	val = [pcdBright selectedTag];
	if (val != pcdBrightValue) {
		pcdflag = YES;
                [usrdef setInteger:(pcdBrightValue = val) forKey:pcdBRIGHT];
	}
	if (pcdflag)
		[ToyWinPCD setBase:pcdSizeValue bright:pcdBrightValue];

	bval = ([adIgnoreSW state] != 0);
	if (bval != adIgnoreDots) {
		adIgnoreDots = bval;
		[usrdef setBool:bval forKey:adIGNOREDOTS];
	} 
	bval = ([origSW selectedTag] != 0);
	if (bval != origSWValue) {
		origSWValue = bval;
		[usrdef setBool:bval forKey:originUL];
		(void)[ToyView setOriginUpperLeft: origSWValue];
	}
	val = [positionSW selectedTag];
	if (val != windowPosValue) {
		windowPosValue = val;
		[usrdef setObject:winPosKey[windowPosValue] forKey:winPOSITION];
		(void)[ToyWin displayOverKeyWindow: (windowPosValue == pos_Fix)];
	}
	val = [transSW selectedTag];
	if (val != transColorValue) {
		transColorValue = val;
		[usrdef setObject:(transColorValue ? @"White" : @"Black")
			forKey:transCOLOR];
		[ToyView setTransColorBlack:(transColorValue == 0)];
		setGIFWrongIndexBlack(transColorValue == 0);
	}
	val = [timedAltSW state];
	if (val != timedAltValue) {
		timedAltValue = val;
		[usrdef setBool:(val != 0) forKey:timedALERT];
		[AlertShower setTimedAlert: timedAltValue];
	}
	bval = ([updateSvcSW state] != 0);
	if (bval != updateSvcValue) {
		updateSvcValue = bval;
		[usrdef setBool:bval forKey:updateSVC];
	} 
#ifndef __APPLE__
	bval = ([unixExpertSW state] != 0);
	if (bval != unixExpertValue) {
		unixExpertValue = bval;
		[usrdef setBool:bval forKey:unixExpert];
	}
#endif
}

- (void)changeWell:sender
{
	NSColor *cl;
	float	buf[4];
	int	i, v, tag;
	NSMutableArray *ar;

	tag = [sender tag];
	cl = [sender color];
	cl = [cl colorUsingColorSpaceName:NSCalibratedRGBColorSpace];
	[cl getRed:&buf[0] green:&buf[1] blue:&buf[2] alpha:NULL];
	for (i = 0; i < 3; i++)
		if (buf[i] != backg[tag][i]) break;
	if (i >= 3)
		return;
	ar = [NSMutableArray arrayWithCapacity: 3];
	for (i = 0; i < 3; i++) {
		backg[tag][i] = buf[i];
		v = buf[i] * 255.0;
		[ar addObject:[NSString localizedStringWithFormat:@"%d", v]];
	}
	[usrdef setObject:ar forKey:backgCOLOR[tag]];
}

- (int)autoDisplayInterval { return adIntervalValue; }

- (int)allWinDisplayInterval { return winIntervalValue; }

- (BOOL)ignoreDottedFiles { return adIgnoreDots; }

- (int)windowPosition { return windowPosValue; }

- (NSPoint)topLeftPoint { return topLeftPoint; }

- (void)setPosition:(id)sender
{
	int tag = [sender tag];
	NSRect rect = [positionPanel frame];
	if (tag == 0) {
		NSArray *ar;
		topLeftPoint.x = rect.origin.x;
		topLeftPoint.y
		    = screenSize.height - (rect.origin.y + rect.size.height);
		ar = [NSArray arrayWithObjects:
			[NSString stringWithFormat:@"%d", (int)topLeftPoint.x],
			[NSString stringWithFormat:@"%d", (int)topLeftPoint.y],
			nil];
		[usrdef setObject:ar forKey:topLeftPOINT];
	}
	[positionPanel close];
}

- (void)showPositionPanel:(id)sender
{
	NSPoint pnt;

	pnt.x = topLeftPoint.x;
	pnt.y = screenSize.height - topLeftPoint.y;
	[positionPanel setFrameTopLeftPoint:pnt];
	[positionPanel makeKeyAndOrderFront:self];
	[positionPanel setFloatingPanel:YES];
}

- (BOOL)isUpdatedServices { return updateSvcValue; }

- (void)backgroungColor:(float *)colors front:(BOOL)flag
{
	int i;
	int well = flag ? 1 : 0;
	for (i = 0; i < 3; i++)
		colors[i] = backg[well][i];
}

- (void)windowWillClose:(NSNotification *)aNotification
{
	int	val;

	val = [adIntSlider intValue];
	if (val != adIntervalValue)
                [usrdef setInteger:(adIntervalValue=val) forKey:adINTERVAL];
	val = [winIntSlider intValue];
	if (val != winIntervalValue)
                [usrdef setInteger:(winIntervalValue=val) forKey:winINTERVAL];
}

@end
