#include  <stdlib.h>
#include  <objc/objc.h>
#include  "../common.h"

#define  m_216		1
#define  m_128		3
#define  m_64		7
#define  m_32		0x0F
#define  m_16		0x1F
#define  b_216		1
#define  b_128		2
#define  b_64		4
#define  b_32		8
#define  b_16		0x10

typedef struct {
	unsigned char pal[3];
	unsigned char mask;
} syspaltype;

static syspaltype win216[] = {
	{ { 0x00, 0x00, 0x00 }, m_16 },
	{ { 0x00, 0x00, 0x33 }, m_64 },
	{ { 0x00, 0x00, 0x66 }, m_32 },
	{ { 0x00, 0x00, 0x99 }, m_16 },
	{ { 0x00, 0x00, 0xCC }, m_32 },
	{ { 0x00, 0x00, 0xFF }, m_16 },
	{ { 0x33, 0x00, 0x00 }, m_64 },
	{ { 0x33, 0x00, 0x33 }, m_64 },
	{ { 0x33, 0x00, 0x66 }, m_216 },
	{ { 0x33, 0x00, 0x99 }, m_216 },
	{ { 0x33, 0x00, 0xCC }, m_216 },
	{ { 0x33, 0x00, 0xFF }, m_128 },
	{ { 0x66, 0x00, 0x00 }, m_32 },
	{ { 0x66, 0x00, 0x33 }, m_216 },
	{ { 0x66, 0x00, 0x66 }, m_32 },
	{ { 0x66, 0x00, 0x99 }, m_216 },
	{ { 0x66, 0x00, 0xCC }, m_216 },
	{ { 0x66, 0x00, 0xFF }, m_128 },
	{ { 0x99, 0x00, 0x00 }, m_16 },
	{ { 0x99, 0x00, 0x33 }, m_216 },
	{ { 0x99, 0x00, 0x66 }, m_216 },
	{ { 0x99, 0x00, 0x99 }, m_16 },
	{ { 0x99, 0x00, 0xCC }, m_216 },
	{ { 0x99, 0x00, 0xFF }, m_128 },
	{ { 0xCC, 0x00, 0x00 }, m_32 },
	{ { 0xCC, 0x00, 0x33 }, m_216 },
	{ { 0xCC, 0x00, 0x66 }, m_216 },
	{ { 0xCC, 0x00, 0x99 }, m_216 },
	{ { 0xCC, 0x00, 0xCC }, m_32 },
	{ { 0xCC, 0x00, 0xFF }, m_128 },
	{ { 0xFF, 0x00, 0x00 }, m_16 },
	{ { 0xFF, 0x00, 0x33 }, m_128 },
	{ { 0xFF, 0x00, 0x66 }, m_128 },
	{ { 0xFF, 0x00, 0x99 }, m_128 },
	{ { 0xFF, 0x00, 0xCC }, m_128 },
	{ { 0xFF, 0x00, 0xFF }, m_16 },
	{ { 0x00, 0x33, 0x00 }, m_64 },
	{ { 0x00, 0x33, 0x33 }, m_64 },
	{ { 0x00, 0x33, 0x66 }, m_216 },
	{ { 0x00, 0x33, 0x99 }, m_216 },
	{ { 0x00, 0x33, 0xCC }, m_216 },
	{ { 0x00, 0x33, 0xFF }, m_128 },
	{ { 0x33, 0x33, 0x00 }, m_64 },
	{ { 0x33, 0x33, 0x33 }, m_64 },
	{ { 0x33, 0x33, 0x66 }, m_128 },
	{ { 0x33, 0x33, 0x99 }, m_128 },
	{ { 0x33, 0x33, 0xCC }, m_128 },
	{ { 0x33, 0x33, 0xFF }, m_64 },
	{ { 0x66, 0x33, 0x00 }, m_216 },
	{ { 0x66, 0x33, 0x33 }, m_128 },
	{ { 0x66, 0x33, 0x66 }, m_128 },
	{ { 0x66, 0x33, 0x99 }, m_216 },
	{ { 0x66, 0x33, 0xCC }, m_216 },
	{ { 0x66, 0x33, 0xFF }, m_216 },
	{ { 0x99, 0x33, 0x00 }, m_216 },
	{ { 0x99, 0x33, 0x33 }, m_128 },
	{ { 0x99, 0x33, 0x66 }, m_216 },
	{ { 0x99, 0x33, 0x99 }, m_128 },
	{ { 0x99, 0x33, 0xCC }, m_216 },
	{ { 0x99, 0x33, 0xFF }, m_216 },
	{ { 0xCC, 0x33, 0x00 }, m_128 },
	{ { 0xCC, 0x33, 0x33 }, m_128 },
	{ { 0xCC, 0x33, 0x66 }, m_216 },
	{ { 0xCC, 0x33, 0x99 }, m_216 },
	{ { 0xCC, 0x33, 0xCC }, m_128 },
	{ { 0xCC, 0x33, 0xFF }, m_128 },
	{ { 0xFF, 0x33, 0x00 }, m_128 },
	{ { 0xFF, 0x33, 0x33 }, m_64 },
	{ { 0xFF, 0x33, 0x66 }, m_216 },
	{ { 0xFF, 0x33, 0x99 }, m_216 },
	{ { 0xFF, 0x33, 0xCC }, m_216 },
	{ { 0xFF, 0x33, 0xFF }, m_64 },
	{ { 0x00, 0x66, 0x00 }, m_32 },
	{ { 0x00, 0x66, 0x33 }, m_216 },
	{ { 0x00, 0x66, 0x66 }, m_32 },
	{ { 0x00, 0x66, 0x99 }, m_216 },
	{ { 0x00, 0x66, 0xCC }, m_216 },
	{ { 0x00, 0x66, 0xFF }, m_128 },
	{ { 0x33, 0x66, 0x00 }, m_216 },
	{ { 0x33, 0x66, 0x33 }, m_128 },
	{ { 0x33, 0x66, 0x66 }, m_128 },
	{ { 0x33, 0x66, 0x99 }, m_216 },
	{ { 0x33, 0x66, 0xCC }, m_216 },
	{ { 0x33, 0x66, 0xFF }, m_216 },
	{ { 0x66, 0x66, 0x00 }, m_32 },
	{ { 0x66, 0x66, 0x33 }, m_128 },
	{ { 0x66, 0x66, 0x66 }, m_32 },
	{ { 0x66, 0x66, 0x99 }, m_128 },
	{ { 0x66, 0x66, 0xCC }, m_128 },
	{ { 0x66, 0x66, 0xFF }, m_64 },
	{ { 0x99, 0x66, 0x00 }, m_64 },
	{ { 0x99, 0x66, 0x33 }, m_216 },
	{ { 0x99, 0x66, 0x66 }, m_128 },
	{ { 0x99, 0x66, 0x99 }, m_128 },
	{ { 0x99, 0x66, 0xCC }, m_216 },
	{ { 0x99, 0x66, 0xFF }, m_64 },
	{ { 0xCC, 0x66, 0x00 }, m_216 },
	{ { 0xCC, 0x66, 0x33 }, m_216 },
	{ { 0xCC, 0x66, 0x66 }, m_128 },
	{ { 0xCC, 0x66, 0x99 }, m_216 },
	{ { 0xCC, 0x66, 0xCC }, m_128 },
	{ { 0xCC, 0x66, 0xFF }, m_216 },
	{ { 0xFF, 0x66, 0x00 }, m_128 },
	{ { 0xFF, 0x66, 0x33 }, m_216 },
	{ { 0xFF, 0x66, 0x66 }, m_64 },
	{ { 0xFF, 0x66, 0x99 }, m_216 },
	{ { 0xFF, 0x66, 0xCC }, m_216 },
	{ { 0xFF, 0x66, 0xFF }, m_64 },
	{ { 0x00, 0x99, 0x00 }, m_16 },
	{ { 0x00, 0x99, 0x33 }, m_216 },
	{ { 0x00, 0x99, 0x66 }, m_216 },
	{ { 0x00, 0x99, 0x99 }, m_16 },
	{ { 0x00, 0x99, 0xCC }, m_216 },
	{ { 0x00, 0x99, 0xFF }, m_128 },
	{ { 0x33, 0x99, 0x00 }, m_216 },
	{ { 0x33, 0x99, 0x33 }, m_128 },
	{ { 0x33, 0x99, 0x66 }, m_216 },
	{ { 0x33, 0x99, 0x99 }, m_128 },
	{ { 0x33, 0x99, 0xCC }, m_216 },
	{ { 0x33, 0x99, 0xFF }, m_216 },
	{ { 0x66, 0x99, 0x00 }, m_64 },
	{ { 0x66, 0x99, 0x33 }, m_216 },
	{ { 0x66, 0x99, 0x66 }, m_128 },
	{ { 0x66, 0x99, 0x99 }, m_128 },
	{ { 0x66, 0x99, 0xCC }, m_216 },
	{ { 0x66, 0x99, 0xFF }, m_64 },
	{ { 0x99, 0x99, 0x00 }, m_16 },
	{ { 0x99, 0x99, 0x33 }, m_128 },
	{ { 0x99, 0x99, 0x66 }, m_128 },
	{ { 0x99, 0x99, 0x99 }, m_16 },
	{ { 0x99, 0x99, 0xCC }, m_128 },
	{ { 0x99, 0x99, 0xFF }, m_64 },
	{ { 0xCC, 0x99, 0x00 }, m_216 },
	{ { 0xCC, 0x99, 0x33 }, m_216 },
	{ { 0xCC, 0x99, 0x66 }, m_216 },
	{ { 0xCC, 0x99, 0x99 }, m_128 },
	{ { 0xCC, 0x99, 0xCC }, m_128 },
	{ { 0xCC, 0x99, 0xFF }, m_216 },
	{ { 0xFF, 0x99, 0x00 }, m_128 },
	{ { 0xFF, 0x99, 0x33 }, m_216 },
	{ { 0xFF, 0x99, 0x66 }, m_216 },
	{ { 0xFF, 0x99, 0x99 }, m_64 },
	{ { 0xFF, 0x99, 0xCC }, m_216 },
	{ { 0xFF, 0x99, 0xFF }, m_32 },
	{ { 0x00, 0xCC, 0x00 }, m_32 },
	{ { 0x00, 0xCC, 0x33 }, m_216 },
	{ { 0x00, 0xCC, 0x66 }, m_216 },
	{ { 0x00, 0xCC, 0x99 }, m_216 },
	{ { 0x00, 0xCC, 0xCC }, m_32 },
	{ { 0x00, 0xCC, 0xFF }, m_128 },
	{ { 0x33, 0xCC, 0x00 }, m_128 },
	{ { 0x33, 0xCC, 0x33 }, m_128 },
	{ { 0x33, 0xCC, 0x66 }, m_216 },
	{ { 0x33, 0xCC, 0x99 }, m_216 },
	{ { 0x33, 0xCC, 0xCC }, m_128 },
	{ { 0x33, 0xCC, 0xFF }, m_128 },
	{ { 0x66, 0xCC, 0x00 }, m_216 },
	{ { 0x66, 0xCC, 0x33 }, m_216 },
	{ { 0x66, 0xCC, 0x66 }, m_128 },
	{ { 0x66, 0xCC, 0x99 }, m_216 },
	{ { 0x66, 0xCC, 0xCC }, m_128 },
	{ { 0x66, 0xCC, 0xFF }, m_216 },
	{ { 0x99, 0xCC, 0x00 }, m_216 },
	{ { 0x99, 0xCC, 0x33 }, m_216 },
	{ { 0x99, 0xCC, 0x66 }, m_216 },
	{ { 0x99, 0xCC, 0x99 }, m_128 },
	{ { 0x99, 0xCC, 0xCC }, m_128 },
	{ { 0x99, 0xCC, 0xFF }, m_216 },
	{ { 0xCC, 0xCC, 0x00 }, m_32 },
	{ { 0xCC, 0xCC, 0x33 }, m_128 },
	{ { 0xCC, 0xCC, 0x66 }, m_128 },
	{ { 0xCC, 0xCC, 0x99 }, m_128 },
	{ { 0xCC, 0xCC, 0xCC }, m_16 },
	{ { 0xCC, 0xCC, 0xFF }, m_64 },
	{ { 0xFF, 0xCC, 0x00 }, m_128 },
	{ { 0xFF, 0xCC, 0x33 }, m_216 },
	{ { 0xFF, 0xCC, 0x66 }, m_216 },
	{ { 0xFF, 0xCC, 0x99 }, m_216 },
	{ { 0xFF, 0xCC, 0xCC }, m_64 },
	{ { 0xFF, 0xCC, 0xFF }, m_64 },
	{ { 0x00, 0xFF, 0x00 }, m_16 },
	{ { 0x00, 0xFF, 0x33 }, m_128 },
	{ { 0x00, 0xFF, 0x66 }, m_128 },
	{ { 0x00, 0xFF, 0x99 }, m_128 },
	{ { 0x00, 0xFF, 0xCC }, m_128 },
	{ { 0x00, 0xFF, 0xFF }, m_16 },
	{ { 0x33, 0xFF, 0x00 }, m_128 },
	{ { 0x33, 0xFF, 0x33 }, m_64 },
	{ { 0x33, 0xFF, 0x66 }, m_216 },
	{ { 0x33, 0xFF, 0x99 }, m_216 },
	{ { 0x33, 0xFF, 0xCC }, m_216 },
	{ { 0x33, 0xFF, 0xFF }, m_64 },
	{ { 0x66, 0xFF, 0x00 }, m_128 },
	{ { 0x66, 0xFF, 0x33 }, m_216 },
	{ { 0x66, 0xFF, 0x66 }, m_64 },
	{ { 0x66, 0xFF, 0x99 }, m_216 },
	{ { 0x66, 0xFF, 0xCC }, m_216 },
	{ { 0x66, 0xFF, 0xFF }, m_64 },
	{ { 0x99, 0xFF, 0x00 }, m_128 },
	{ { 0x99, 0xFF, 0x33 }, m_216 },
	{ { 0x99, 0xFF, 0x66 }, m_216 },
	{ { 0x99, 0xFF, 0x99 }, m_64 },
	{ { 0x99, 0xFF, 0xCC }, m_216 },
	{ { 0x99, 0xFF, 0xFF }, m_32 },
	{ { 0xCC, 0xFF, 0x00 }, m_128 },
	{ { 0xCC, 0xFF, 0x33 }, m_216 },
	{ { 0xCC, 0xFF, 0x66 }, m_216 },
	{ { 0xCC, 0xFF, 0x99 }, m_216 },
	{ { 0xCC, 0xFF, 0xCC }, m_64 },
	{ { 0xCC, 0xFF, 0xFF }, m_64 },
	{ { 0xFF, 0xFF, 0x00 }, m_16 },
	{ { 0xFF, 0xFF, 0x33 }, m_64 },
	{ { 0xFF, 0xFF, 0x66 }, m_64 },
	{ { 0xFF, 0xFF, 0x99 }, m_32 },
	{ { 0xFF, 0xFF, 0xCC }, m_64 },
	{ { 0xFF, 0xFF, 0xFF }, m_16 },
	{ { 0xFF, 0xFF, 0xFF }, 0 } /* Sentinel */
};

#ifdef  USE_SYS16
static paltype win16[] = {
	{ 0x00, 0x00, 0x00 },
	{ 0x99, 0x00, 0x00 },
	{ 0x00, 0x99, 0x00 },
	{ 0x99, 0x99, 0x00 },
	{ 0x00, 0x00, 0x99 },
	{ 0x99, 0x00, 0x99 },
	{ 0x00, 0x99, 0x99 },
	{ 0xCC, 0xCC, 0xCC },
	{ 0x99, 0x99, 0x99 },
	{ 0xFF, 0x00, 0x00 },
	{ 0x00, 0xFF, 0x00 },
	{ 0xFF, 0xFF, 0x00 },
	{ 0x00, 0x00, 0xFF },
	{ 0xFF, 0x00, 0xFF },
	{ 0x00, 0xFF, 0xFF },
	{ 0xFF, 0xFF, 0xFF }
};
#endif

paltype *getSysPalette(int colors)
{
	static paltype pal[217];
	int	bt;
	int	x, pp, i;

	bt = b_16;
	if (colors >= 216)
		bt = b_216;
	else if (colors >= 128)
		bt = b_128;
	else if (colors >= 64)
		bt = b_64;
	else if (colors >= 32)
		bt = b_32;
	for (x = 0, pp = 0; win216[x].mask; x++)
		if (win216[x].mask & bt) {
			for (i = 0; i < 3; i++)
				pal[pp][i] = win216[x].pal[i];
			if (++pp >= colors)
				break;
		}
	return pal;
}
