#import  "TVController.h"
#import  <AppKit/NSApplication.h>
#import  <AppKit/NSControl.h>
#import  <AppKit/NSMenuItem.h>
#import  <AppKit/NSImage.h>
#import  <AppKit/NSWorkspace.h>
#import  <Foundation/NSData.h>
#import  <Foundation/NSUserDefaults.h>
#import  <Foundation/NSPathUtilities.h>
#import  <Foundation/NSFileManager.h>
#import  "NSStringAppended.h"
#import  <stdio.h>
#import  <stdlib.h>
#import  <string.h>
#import  <libc.h>
#import  <bsd/libc.h>
#import  <mach/mach_init.h>
#import  <sys/types.h>
#import  <time.h>
#import  "BundleLoader.h"
#import  "ToyWin.h"
#import  "ToyWinEPS.h"
#import  "ToyView.h"
#import  "BackgCtr.h"
#import  "AlertShower.h"
#import  "common.h"
#import  "strfunc.h"
#import  "backgops.h"

@implementation TVController (BackgroundManager)

/* Local Method */
- readRCWallpaper
{
	char	buf[MAXFILENAMELEN];
	int	i, n, cc, ln, method;
	NSData	*stream;
	NSString *filename, *rcpath;
	NSFileManager *manager;
	FILE	*fp;

	rcpath = [@"~/Library/ToyViewer/rc.wallpaper"
			stringByExpandingTildeInPath];
	if ((fp = fopen([rcpath cStringInFS], "r")) == NULL)
		return nil;
	buf[0] = 0;
	for (ln = 0; fgets(buf, MAXFILENAMELEN, fp); ) {
		if (buf[0] == '#') continue;
		for (i = 0; i < 4 && buf[i]; i++) ;
		if (i < 4) break;
		ln++;
	}
	n = 1;
	if (ln > 1) {
		static int prev = -1;
		n = ((int)time(NULL) >> 1) % ln + 1;
		if (n == prev)
			n = (n % ln) + 1;
		prev = n;
	}
	rewind(fp);
	for (i = 0; i < n; ) {
		fgets(buf, MAXFILENAMELEN, fp);
		if (buf[0] == '#') continue;
		i++;
	}
	fclose(fp);
	method = bk_CoverScreen; /* default */
	for (i = 0; i < MAXFILENAMELEN - 4; i++) {
		if ((cc = buf[i] & 0xff) == ' ' || cc == '\t') {
			buf[i] = 0;
			while ((cc = buf[++i] & 0xff) == ' ' || cc == '\t') ;
			switch (cc) {
			case 'c':  case 'C': /* Centering */
				method = bk_Centering;  break;
			case 't':  case 'T': /* Tiling */
				method = bk_Tiling;  break;
			case 'b':  case 'B': /* Brick */
				method = bk_BrickWork;  break;
			case 'f':  case 'F': /* Fit */
				method = bk_FitScreen;  break;
			case 'v':  case 'V': /* coVer */
				method = bk_CoverScreen;  break;
			}
			break;
		}
	}

	filename = [NSString stringWithCStringInFS: buf];
	if (buf[0] == '~')
		filename = [filename stringByExpandingTildeInPath];
	manager = [NSFileManager defaultManager];
	if (![manager isReadableFileAtPath:filename]) {
		[ErrAlert runAlert:filename : Err_OPEN];
		return nil;
	}
	stream = [self openDataFromFile:filename];
	if (stream == NULL)
		return nil;
	if (backgCtr == nil)
		backgCtr = [BundleLoader loadAndNew: b_BackgCtr];
	if ([backgCtr setStream: stream with: method] == nil)
		[WarnAlert runAlert:filename : Err_MEMORY];
	return self;
}

- (id)initWallpaper
{
	NSUserDefaults *df = [NSUserDefaults standardUserDefaults];
/* For NX... defaults (NEXTSTEP) */
	if ([df stringForKey:@"NXServiceLaunch"] != nil
		|| [df stringForKey:@"NXOpen"] != nil)
		return self;
/* For NS... defaults (OPENSTEP, maybe) */
	if ([df stringForKey:@"NSServiceLaunch"] != nil
		|| [df stringForKey:@"NSOpen"] != nil)
		return self;
	[self readRCWallpaper];
	return self;
}

- (void)readWallpaperSetting:sender
{
	if ([self readRCWallpaper] == nil)
		NSBeep(); 
}


- (void)cleanBackground:sender
{
	if (backgCtr == nil)
		NSBeep();
	else
		[backgCtr cleanBackground: sender];
}

- (void)backgMenuEnabled:(BOOL)flag
{
	hasBGW = flag;
	[menuToFront setEnabled:flag];
	[menuClear setEnabled:flag]; 
}

- (void)toggleFront:sender
{
	if (backgCtr == nil)
		NSBeep();
	else
		[backgCtr toggleFront:sender];
}

- (void)backWinFront:(BOOL)flag
{
	[menuToFront setTitle: flag
		? NSLocalizedString(@"Send to Back", Background)
		: NSLocalizedString(@"Bring to Front", Background)
	];
}

- (void)makeBackground:sender
{
	NSRect	ir;
	id	tw, tv, rtn;
	commonInfo *cinf;
	int method = [sender tag];
	
	if ((tw = [self keyWindow]) == nil) {
		NSBeep();
		return;
	}
	tv = [tw toyView];
	if (backgCtr == nil)
		backgCtr = [BundleLoader loadAndNew: b_BackgCtr];
	cinf = [tv commonInfo];
	ir = [tv selectedRect];
	rtn = nil;
	if (ir.size.width > 0.0 && ir.size.height > 0.0) {
		id tmp = [NSImage allocWithZone:[self zone]];
		[tmp initWithData: [tv dataWithEPSInsideRect: ir]];
		[tmp setScalesWhenResized:YES];
		rtn = [backgCtr setImage: tmp hasAlpha: cinf->alpha with: method];
		[tmp release];
	}else if ([tw isKindOfClass:[ToyWinEPS class]]) {
		NSData *stream = [tw openEPSData];
		rtn = [backgCtr setStream: stream with: method];
		// [stream release];
	}else
		rtn = [backgCtr setImage: [tv image] hasAlpha: cinf->alpha with: method];
	if (rtn == nil)
		[WarnAlert runAlert:[tw filename] : Err_MEMORY];
}

@end
