#import  <Foundation/NSObject.h>
#import  <AppKit/NSView.h>
#import  "common.h"

@class NSImage, NSImageRep, NSTextField, PrefControl, NSData;

@interface ToyView: NSView
{
	NSImage		*image;
	NSSize		origSize;
	NSSize		curSize;
	float		scaleFactor;
	float		backgray;
	unsigned char	*rawmap;
	commonInfo	*comInfo;
	NSRect		selectRect;
	NSTextField	*commText;
}

- initWithContentsOfFile:(NSString *)filename;
- initFromData:(NSData *)data;
- initDataPlanes:(unsigned char **)planes info:(commonInfo *)cinf;
- (void)setCommText:(NSTextField *)text;
- (NSSize)originalSize;
- (NSSize)resize:(float)factor;
- (void)dealloc;
- (NSImage *)image;
- (commonInfo *)commonInfo;
- (float)scaleFactor;
- (NSRect)selectedRect;
- (NSRect)selectedScaledRect;

- (void)beginPrologueBBox:(NSRect)boundingBox creationDate:(NSString *)dateCreated createdBy:(NSString *)anApplication fonts:(NSString *)fontNames forWhom:(NSString *)user pages:(int)numPages title:(NSString *)aTitle;	/* Overload */

@end


@interface ToyView (EventHandling)

+ cursor;
+ (BOOL)setOriginUpperLeft:(BOOL)flag;
+ (void)setTransColorBlack:(BOOL)flag;
- (BOOL)acceptsFirstResponder;
- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent;
- (void)resetCursorRects;			/* Overload */

- (void)setDraggedLine:sender;
- (void)clearDraggedLine;
- (void)rewriteComment;
- (void)mouseDown:(NSEvent *)event;		/* Overload */
- (void)selectAll:(id)sender;			/* Overload */
- (void)copy:(id)sender;				/* Overload */
- (void)drawRect:(NSRect)r;	/* Overload */

@end

/* Local in Class ToyView */
extern BOOL transBlack;
