#import <Foundation/NSObject.h>
#import <AppKit/NSGraphics.h>
#import "common.h"

@class NSImage, NSWindow, ToyView;

#define  mini_YET	0
#define  mini_DEMINI	1
#define  mini_MINI	2

extern BOOL displayOverKeyWindowFlag;

@interface ToyWin: NSObject
{
	id	thiswindow;
	id	scView;
	id	commentText;
	id	parental;
	int 	operation;
	float	scaleFactor;
	NSString  *imageFilename;
	id	scalePanel;
	id	scaleText;
	int	miniFlag;
	BOOL	makeMapOnly;
}

+ (void)initialize;
+ (BOOL)displayOverKeyWindow:(BOOL)flag;
- init;
- init: parent by:(int)op;
- initMapOnly;
- (void)dealloc;
- (NSString *)filename;
- (void)resetFilename:(NSString *)fileName;
- (NSWindow *)window;
- toyView;
- parent;
- (int)madeby;
- (void)reScale:sender;
- (void)setScale:sender;
- initLocateWindow:(NSString *)fileName width:(int)width height:(int)height;
- (void)scrollProperly;
- (BOOL)hasCounterpart;

/* delegate methods */
- (void)windowDidMiniaturize:(NSNotification *)notification;
- (void)windowDidDeminiaturize:(NSNotification *)notification;
- (BOOL)windowShouldClose:(id)sender;
- (void)windowDidBecomeKey:(NSNotification *)notification;
- (void)windowDidExpose:(NSNotification *)notification;
- (void)windowDidMove:(NSNotification *)notification;

@end


@interface ToyWin (Drawing)

- (commonInfo *)drawToyWin:(NSString *)fileName type:(int)type
	map:(unsigned char **)map err:(int *)err;
- drawView:(unsigned char **)map info:(commonInfo *)cinf;
- (int)drawFromFile:(NSString *)fileName or:(NSData *)data;
- (void)makeComment:(commonInfo *)cinf;
- (void)makeComment:(commonInfo *)cinf from:(const commonInfo *)originfo;

@end


@interface ToyWin (Saving)

- (NSData *)openEPSData;
- (int)getBitmap:(unsigned char **)map info:(commonInfo **)infp;
- (void)freeTempBitmap;
	/* freeTempBitmap must be called after getBitmap:info: */
- (void)print:(id)sender;

@end
