#import <AppKit/psopsOpenStep.h>	/* for PSxxx functions */
#import <AppKit/NSControl.h>
#import <AppKit/NSTextField.h>
#import <AppKit/NSScrollView.h>
/* #import <AppKit/tiff.h>		 NXImageBitmap */
#import <AppKit/NSGraphics.h>
#import <AppKit/AppKit.h>
#import <Foundation/NSBundle.h>		/* LocalizedString */
#import "NSStringAppended.h"
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import "ToyWin.h"
#import "ToyView.h"
#import "TVController.h"
#import "strfunc.h"


@implementation ToyWin (Drawing)

/* Local Method */
- (void)draw_setting
{
	[scView setHasHorizontalScroller:YES];
	[scView setHasVerticalScroller:YES];
	[scView setBorderType:NSNoBorder];
	// [commentText setSelectable: YES];
	// [commentText setEditable: NO];
}

- drawView:(unsigned char **)map info:(commonInfo *)cinf
{
	ToyView *view;
	id tmp;

	[self draw_setting];
	tmp = [ToyView alloc];
	if ((view = [tmp initDataPlanes:map info:cinf]) == nil) {
		[tmp release];
		return nil;
	}
        [view setCommText:commentText];
	[scView setDocumentView:view];
	[scView setCopiesOnScroll:YES];
	[self scrollProperly];
	[thiswindow display];
	[thiswindow makeKeyAndOrderFront:self];
	[commentText setStringValue:
		[NSString stringWithCStringInEUC:cinf->memo]];
	PSWait();
	return self;
}


- (int)drawFromFile:(NSString *)fileName or:(NSData *)data
{
	id tmp, view;
	commonInfo *cinf;

	[self draw_setting];
	tmp = [ToyView alloc];
	view = data
		? [tmp initFromData: data]
		: [tmp initWithContentsOfFile:fileName];
	if (view == nil) {
		[tmp release];
		return Err_OPEN;
	}
	[view setCommText:commentText];
	cinf = [view commonInfo];
	[self initLocateWindow:fileName width:cinf->width height:cinf->height];
	[self makeComment:cinf];
	[commentText setStringValue:
		[NSString stringWithCStringInEUC:cinf->memo]];
	[scView setDocumentView:view];
	[scView setCopiesOnScroll:YES];
	[self scrollProperly];
	[thiswindow display];
	[thiswindow makeKeyAndOrderFront:self];
	PSWait();
	return 0;
}

- (void)makeComment:(commonInfo *)cinf
{
	const char *alp = cinf->alpha ? "  Alpha" : "";
	const char *bilv;

	if (cinf->bits == 1 && cinf->numcolors <= 2) {
		bilv = [NSLocalizedString(@"Bilevel", Bilevel) cStringInEUC];
		sprintf(cinf->memo, "%d x %d  %s%s",
			cinf->width, cinf->height, bilv, alp);
	}else {
		sprintf(cinf->memo, "%d x %d  %dbit%s",
			cinf->width, cinf->height, cinf->bits,
			((cinf->bits > 1) ? "s" : ""));
		if (cinf->numcolors <= 2) {
			strcat(cinf->memo, " ");
			strcat(cinf->memo,
			[NSLocalizedString(@"gray", gray) cStringInEUC]);
		}else if (cinf->cspace == CS_CMYK)
			strcat(cinf->memo, " CMYK");
		strcat(cinf->memo, alp);
	}
}

- (void)makeComment:(commonInfo *)cinf from:(const commonInfo *)originfo
{
	const char *p;

	[self makeComment:cinf];
	if ((p = begin_comm(originfo->memo, YES)) != NULL) {
		strcat(cinf->memo, " : ");
		comm_cat(cinf->memo, p);
	} 
}

- (commonInfo *)drawToyWin:(NSString *)fileName type:(int)type
	map:(unsigned char **)map err:(int *)err
{
	if (type == Type_TIFF) {
		NSData *stream;
		if ((stream = [NSMutableData dataWithCapacity: 0]) == nil)
			return NULL;
		[stream initWithContentsOfFile:fileName];
		*err = [self drawFromFile:fileName or:stream];
	}else
		*err = [self drawFromFile:fileName or:NULL];
	return NULL;
}

@end
