/*
	gif.h

	gifheader.c, gifbmap.c, and gif.h are based on "giftoppm"
	of David Koblas.
	They are modified by T. Ogihara. (1996)
*/

/* +-------------------------------------------------------------------+ */
/* | Copyright 1990, David Koblas.                                     | */
/* |   Permission to use, copy, modify, and distribute this software   | */
/* |   and its documentation for any purpose and without fee is hereby | */
/* |   granted, provided that the above copyright notice appear in all | */
/* |   copies and that both that copyright notice and this permission  | */
/* |   notice appear in supporting documentation.  This software is    | */
/* |   provided "as is" without express or implied warranty.           | */
/* +-------------------------------------------------------------------+ */

#include  <stdio.h>
#include  <stdlib.h>

#define  Err_OPEN	1
#define  Err_FORMAT	2
#define  Err_MEMORY	3
#define  Err_SHORT	4
#define  Err_ILLG	5
#define  Err_IMPLEMENT	6
#define  Err_SAVE	7
#define  Err_SAV_IMPL	8
#define  Err_EPS_IMPL	9
#define  Err_EPS_ONLY	10
#define  Err_OPR_IMPL	11
#define  Err_NOFILE	12
#define  Err_FLT_EXEC	13

#define  RED	0
#define  GREEN	1
#define  BLUE	2
#define  ALPHA	3
#define  FIXcount	256
#define  MAXPLANE	5
#define  MAXWidth	4096	/* β */
#define  MAX_COMMENT	80
#define	 MAXFILENAMELEN	512

#define INTERLACE		0x40
#define LOCALCOLORMAP		0x80
#define TRANSPARENCY		0x01
#define BitSet(byte, bit)	(((byte) & (bit)) == (bit))
#define	ReadOK(file,buffer,len)	(fread(buffer, len, 1, file) != 0)

#ifndef BOOL
# define BOOL	int
# define YES	1
# define NO	0
#endif

typedef unsigned char	paltype[3];

typedef struct {
	int		width;
	int		height;
	int		colors;
	int		bits;		/* bits per sample */
	int		transp;		/* Transparency Index */
	unsigned short	Resolution;
	unsigned short	Background;
	unsigned short	AspectRatio;
	BOOL		colormap;
	BOOL		interlace;
	BOOL		isgray;
	char		ver[4];
	paltype		palette[256];
	unsigned char	*memo;
} gifHeader;

gifHeader *loadGifHeader(FILE *fd, int *errcode);
void freeGifHeader(gifHeader *gh);

int gif_to_pxo(gifHeader *, FILE *, FILE *);
int GetDataBlock(FILE *, unsigned char *);
int initGifLZW(FILE *);
int LWZReadByte(FILE *);
