#include  <stdio.h>
#include  <string.h>
#include  "gif.h"

static void usage(const char *toolname)
{
	fprintf(stderr, "gif2pxo (2000-02-20)\n");
	fprintf(stderr, "Usage: %s [-info] gif_file\n", toolname);
}

static void displayInfo(gifHeader *gh)
{
	int	i;
	unsigned char *p;

	printf("GIF");
	for (i = 0; i < 4 && gh->ver[i]; i++)
		putchar(gh->ver[i]);
	putchar('\n');
	printf("Size: %d x %d\n", gh->width, gh->height);
	printf("Colors: %d\n", gh->colors);
	printf("Bits/Sample: %d\n", gh->bits);
	printf("Transparent: %d\n", gh->transp);
	printf("Resolution: %d\n", gh->Resolution);
	printf("Background: %d\n", gh->Background);
	printf("AspectRatio: %d\n", gh->AspectRatio);
	printf("ColorMap: %s\n", gh->colormap ? "yes" : "no");
	printf("Interlace: %s\n", gh->interlace ? "yes" : "no");
	printf("Gray: %s\n", gh->isgray ? "yes" : "no");
	printf("Palette:\n");
	for (i = 0; i < gh->colors; i++) {
		p = gh->palette[i];
		printf("%3d[%02x %02x %02x]", i, p[0], p[1], p[2]);
		if ((i & 0x03) == 0x03)
			putchar('\n');
		else
			printf("  ");
	}
}

int main(int argc, char **argv)
{
	FILE *fp;
	gifHeader *gh = NULL;
	int	ac, err = 0;
	int	infoflag = 0;

	for (ac = 1; ac < argc && argv[ac][0] == '-'; ac++) {
		if (strncmp(&argv[ac][1], "info", 4) == 0)
			infoflag = 1;
		else
			fprintf(stderr, 
				"Warning: Unknown option: %s\n", argv[ac]);
	}
	if (ac >= argc) {
		usage(argv[0]);
		return 1;
	}
	if ((fp = fopen(argv[ac], "r")) == NULL) {
		fprintf(stderr, "ERROR: Can't open %s\n", argv[ac]);
		return 1;
	}
	if ((gh = loadGifHeader(fp, &err)) == NULL) {
		fprintf(stderr, "ERROR: Illegal format: %s\n", argv[ac]);
		(void)fclose(fp);
		return 1;
	}
	if (infoflag) {	/* Display info. of the image file */
		err = gif_to_pxo(gh, fp, NULL);
		displayInfo(gh);
	}else
		err = gif_to_pxo(gh, fp, stdout);
	freeGifHeader(gh);
	(void)fclose(fp);
	return err;
}
