/*
	gifHeader.c

	gifheader.c, gifbmap.c, and gif.h are based on "giftoppm"
	of David Koblas.
	They are modified by T. Ogihara. (1995)
*/

/* +-------------------------------------------------------------------+ */
/* | Copyright 1990, David Koblas.                                     | */
/* |   Permission to use, copy, modify, and distribute this software   | */
/* |   and its documentation for any purpose and without fee is hereby | */
/* |   granted, provided that the above copyright notice appear in all | */
/* |   copies and that both that copyright notice and this permission  | */
/* |   notice appear in supporting documentation.  This software is    | */
/* |   provided "as is" without express or implied warranty.           | */
/* +-------------------------------------------------------------------+ */

#include  <stdio.h>
#include  "gif.h"
#include  "strfunc.h"

gifHeader *loadGifHeader(FILE *fd, int *errcode)
{
	unsigned char	buf[16];
	gifHeader *gh;
	int cc;

	if (! ReadOK(fd,buf,6)) {
		*errcode = Err_FORMAT;
		return NULL;
	}
	buf[6] = 0;
	if (strcmp(buf,"GIF87a") != 0 && strcmp(buf,"GIF89a") != 0) {
		*errcode = Err_FORMAT;
		return NULL;
	}
	if ((gh = (gifHeader *)malloc(sizeof(gifHeader))) == NULL) {
		*errcode = Err_MEMORY;
		return NULL;
	}
	gh->width	= get_short(fd);
	gh->height	= get_short(fd);
	gh->colors	= 2 << ((cc = getc(fd)) & 0x07);
	gh->bits	= 8;
	gh->Resolution	= ((cc & 0x70) >> 3) + 1;
	gh->colormap	= BitSet(cc, LOCALCOLORMAP);
	gh->transp	= -1;
	gh->interlace	= BitSet(cc, INTERLACE);
	gh->isgray	= NO;
	gh->Background	= getc(fd);
	gh->AspectRatio	= getc(fd);
	strcpy(gh->ver, buf+3);
	// gh->palette	= ...;
	gh->memo	= NULL;
	return gh;
}

void freeGifHeader(gifHeader *gh)
{
	if (gh) {
		if (gh->memo) free((void *)gh->memo);
		free((void *)gh);
	}
}
