#include  <stdio.h>
#include  <string.h>
#include  "gif.h"
#include  "strfunc.h"

char *str_dup(const char *src)
{
	char *dst;

	dst = (char *)malloc(strlen(src) + 1);
	strcpy(dst, src);
	return dst;
}

int get_short(FILE *fp)
{
	int c = getc(fp);
	return ((getc(fp) << 8) | c);
}

long get_long(FILE *fp)
{
	long c = get_short(fp);
	return ((get_short(fp) << 16) | c);
}

BOOL isGray(paltype *pal, int n)
/* Is Gray-scaled all colors of the palette ? */
{
	int i;
	unsigned char *p;

	if (pal == NULL)
		return NO;
	for (i = 0; i < n; i++) {
		p = pal[i];
		if (p[0] != p[1] || p[1] != p[2])
			return NO;
	}
	return YES;
}
