#include  <stdio.h>
#include  <stdlib.h>
#include  "mag.h"

int main(int argc, char *argv[])
{
	FILE *fp;
	magHeader *mh;
	long base;
	int err;

	if (argc != 2) {
		fprintf(stderr, "usage: %s magfile\n", argv[0]);
		return 1;
	}
	if ((fp = fopen(argv[1], "r")) == NULL)
		return Err_OPEN;

	if ((mh = loadMagHeader(fp, &base, &err)) == NULL) {
		fclose(fp);
		return err;
	}
	err = magDecode(fp, stdout, mh, base);

	free((void *)mh);
	fclose(fp);
	return err;
}
